% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reduce_single_digit.R
\encoding{UTF-8}
\name{reduce_single_digit}
\alias{reduce_single_digit}
\title{Reduce an Integer, a Date (Time), or a Number (with or without Decimals) to a Single Integer}
\usage{
reduce_single_digit(string)
}
\arguments{
\item{string}{character vector coercible to a date using \code{\link[anytime]{anytime}}
or a date time using \code{\link[anytime]{anytime}}; a numeric vector; or an
integer vector}
}
\value{
a numeric vector with a single digit (integer from 0 - 9)
}
\description{
Takes a character vector coercible to a date using \code{\link[anytime]{anydate}} or a date time
using \code{\link[anytime]{anytime}}; a numeric vector; or an integer vector & computes
the sum to a single digit using \code{\link{Mod_octave}}
}
\details{
The vectors may include periods, dashes, parentheses, colons, and/or spaces.
See the examples.
}
\examples{

# Examples

library(iemisc)

reduce_single_digit(37)

reduce_single_digit(5094322.439344993211394)

reduce_single_digit(-438443.349435493)

reduce_single_digit("-48373744582.47362287482374")

reduce_single_digit("11-09-2022")

reduce_single_digit("24 December 1983 04:37:58.55543333")

reduce_single_digit("4 July 1776")

reduce_single_digit(9)

reduce_single_digit(0)

reduce_single_digit(94321155)

reduce_single_digit("011 (704) 904-0432")

reduce_single_digit("011-894-908-0945")

reduce_single_digit("908-0945")







}
\references{
\enumerate{
   \item Numerology.com, "Number 9 Meaning", \url{https://www.numerology.com/articles/about-numerology/single-digit-number-9-meaning/}.
   \item GeeksforGeeks, Last updated on 13 Jun, 2022, "Finding sum of digits of a number until sum becomes single digit", \url{https://www.geeksforgeeks.org/finding-sum-of-digits-of-a-number-until-sum-becomes-single-digit/}.
   \item Wikimedia Foundation, Inc. Wikipedia, 18 November 2022, "Digital root", \url{https://en.wikipedia.org/wiki/Digital_root}.
}
}
\author{
Irucka Embry
}
