% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mage_ma_single.R
\name{mage_ma_single}
\alias{mage_ma_single}
\title{Calculates Mean Amplitude of Glycemic Excursions (see "mage")}
\usage{
mage_ma_single(
  data,
  short_ma = 5,
  long_ma = 32,
  return_type = c("num", "df"),
  direction = c("avg", "service", "max", "plus", "minus"),
  dt0 = NULL,
  tz = "",
  inter_gap = 45,
  max_gap = 180,
  plot = FALSE,
  title = NA,
  xlab = NA,
  ylab = NA,
  show_ma = FALSE,
  show_excursions = TRUE,
  plot_type = c("ggplot", "plotly")
)
}
\arguments{
\item{data}{DataFrame object with column names "id", "time", and "gl". Should only be data for 1 subject. In case multiple subject ids are detected, a warning is produced and only 1st subject is used.}

\item{short_ma}{Integer for period length of the short moving average. \strong{Default: 5.} Must be positive and less than "long_ma". (Recommended <15)}

\item{long_ma}{Integer for period length for the long moving average. \strong{Default: 32.} Must be positive and greater than "short_ma". (Recommended >20)}

\item{return_type}{One of "num" or "df". \strong{Default: "num".} Will return either a single number for the "MAGE over the entire trace" (weighted by segment length) or a DataFrame with the MAGE value for each segment (see the MAGE vignette for discussion of handling gaps by splitting trace into multiple segments).}

\item{direction}{One of "avg", "service", "max", "plus", or "minus". \strong{Default: "avg".} Algorithm will calculate one of the following: MAGE+ (nadir to peak), MAGE- (peak to nadir), MAGEavg = avg(MAGE+, MAGE-), MAGEmax = max(MAGE+, MAGE-), or automatically choose MAGE+/MAGE- based on the first countable excursion (i.e., "service"). NOTE: the selection of peak-to-nadir or nadir-to-peak is chosen independently on each segment, thus MAGEservice may choose peak-to-nadir on one segment and nadir-to-peak on another, for example.}

\item{dt0}{The time frequency for interpolation in minutes, the default will match the CGM meter's frequency (e.g. 5 min for Dexcom).}

\item{tz}{A character string specifying the time zone to be used. System-specific (see \code{\link{as.POSIXct}}), but " " is the current time zone, and "GMT" is UTC (Universal Time, Coordinated). Invalid values are most commonly treated as UTC, on some platforms with a warning.}

\item{inter_gap}{The maximum allowable gap (in minutes) for interpolation. The values will not be interpolated between the glucose measurements that are more than inter_gap minutes apart. The default value is 45 min.}

\item{max_gap}{Integer for the maximum length of a gap in minutes before the trace is split into segments and MAGE is calculated on each segment independently. \strong{Default: 180.}}

\item{plot}{Boolean. \strong{Default: FALSE.} If TRUE, returns a plot that visualizes all identified peaks and nadirs, excursions, and  missing gaps. An interactive GUI can be loaded with \code{plot_type = 'plotly'}.}

\item{title}{Title for the ggplot. \strong{Default: "Glucose Trace - Subject [ID]".}}

\item{xlab}{Label for x-axis of ggplot. \strong{Default: "Time".}}

\item{ylab}{Label for y-axis of ggplot. \strong{Default: "Glucose Level".}}

\item{show_ma}{Boolean. \strong{Default: FALSE.} If TRUE, plots the moving average lines on the plot.}

\item{show_excursions}{Boolean. \strong{Default: TRUE.} If TRUE, shows identified excursions as arrows from peak-to-nadir/nadir-to-peak on the plot.}

\item{plot_type}{One of "ggplot" or "plotly". \strong{Default: "gglplot".} Returns either a ggplot (static image) or Plotly chart (interactive GUI).}
}
\value{
A ggplot or Plotly chart if \code{plot = TRUE}, depending on \code{plot_type}. Otherwise, a numeric MAGE value for the inputted glucose trace or a DataFrame with the MAGE values on each segment, depending on \code{return_type}.
}
\description{
This function is an internal function used by "mage". The function will calculate the Mean Amplitude of Glycemic Excursions (MAGE) on \strong{all} the values of the inputted data set. To calculate separate MAGE values for a group of subjects, use the "mage" function.
}
\details{
See "mage".
}
\examples{
data(example_data_1_subject)
mage_ma_single(
   example_data_1_subject,
   short_ma = 4,
   long_ma = 24,
   direction = 'plus')

mage_ma_single(
   example_data_1_subject,
   inter_gap = 300)

mage_ma_single(
   example_data_1_subject,
   plot=TRUE,
   title="Patient X",
   xlab="Time",
   ylab="Glucose Level (mg/dL)",
   show_ma=FALSE)
}
\author{
Nathaniel J. Fernandes
}
