% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/median_glu.R
\name{median_glu}
\alias{median_glu}
\title{Calculate median glucose level}
\usage{
median_glu(data)
}
\arguments{
\item{data}{DataFrame object with column names "id", "time", and "gl",
or numeric vector of glucose values.}
}
\value{
If a data.frame object is passed, then a tibble object with
two columns: subject id and corresponding median value is returned. If a vector of glucose
values is passed, then a tibble object with just the median value is returned.
as.numeric() can be wrapped around the latter to output just a numeric value.
}
\description{
The function median_glu is a wrapper for the base function
median(). Output is a tibble object with subject id and median values.
}
\details{
A tibble object with 1 row for each subject, a column for subject id and
a column for the median values is returned. NA glucose values are
omitted from the  calculation of the median.
}
\examples{
data(example_data_1_subject)
median_glu(example_data_1_subject)

data(example_data_5_subject)
median_glu(example_data_5_subject)

}
