% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R, R/structural.properties.R
\name{component_distribution}
\alias{component_distribution}
\alias{components}
\alias{no.clusters}
\alias{clusters}
\alias{is.connected}
\alias{cluster.distribution}
\alias{count_components}
\alias{is_connected}
\title{Connected components of a graph}
\usage{
component_distribution(graph, cumulative = FALSE, mul.size = FALSE, ...)

components(graph, mode = c("weak", "strong"))
}
\arguments{
\item{graph}{The graph to analyze.}

\item{cumulative}{Logical, if TRUE the cumulative distirubution (relative
frequency) is calculated.}

\item{mul.size}{Logical. If TRUE the relative frequencies will be multiplied
by the cluster sizes.}

\item{\dots}{Additional attributes to pass to \code{cluster}, right now only
\code{mode} makes sense.}

\item{mode}{Character string, either \dQuote{weak} or \dQuote{strong}.  For
directed graphs \dQuote{weak} implies weakly, \dQuote{strong} strongly
connected components to search. It is ignored for undirected graphs.}
}
\value{
For \code{is_connected} a logical constant.

For \code{components} a named list with three components:
\item{membership}{numeric vector giving the cluster id to which each vertex
belongs.} \item{csize}{numeric vector giving the sizes of the clusters.}
\item{no}{numeric constant, the number of clusters.}

For \code{count_components} an integer constant is returned.

For \code{component_distribution} a numeric vector with the relative
frequencies. The length of the vector is the size of the largest component
plus one. Note that (for currently unknown reasons) the first element of the
vector is the number of clusters of size zero, so this is always zero.
}
\description{
Calculate the maximal (weakly or strongly) connected components of a graph
}
\details{
\code{is_connected} decides whether the graph is weakly or strongly
connected. The null graph is considered disconnected.

\code{components} finds the maximal (weakly or strongly) connected components
of a graph.

\code{count_components} does almost the same as \code{components} but returns only
the number of clusters found instead of returning the actual clusters.

\code{component_distribution} creates a histogram for the maximal connected
component sizes.

The weakly connected components are found by a simple breadth-first search.
The strongly connected components are implemented by two consecutive
depth-first searches.
}
\examples{

g <- sample_gnp(20, 1/20)
clu <- components(g)
groups(clu)

}
\seealso{
\code{\link{decompose}}, \code{\link{subcomponent}}, \code{\link{groups}}
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\keyword{graphs}
