% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.R
\name{sample_tree}
\alias{sample_tree}
\title{Sample trees randomly and uniformly}
\usage{
sample_tree(n, directed = FALSE, method = c("lerw", "prufer"))
}
\arguments{
\item{n}{The number of nodes in the tree}

\item{directed}{Whether to create a directed tree. The edges of the tree are
oriented away from the root.}

\item{method}{The algorithm to use to generate the tree. \sQuote{prufer}
samples Prüfer sequences uniformly and then converts the sampled sequence to
a tree. \sQuote{lerw} performs a loop-erased random walk on the complete
graph to uniformly sampleits spanning trees. (This is also known as Wilson's
algorithm). The default is \sQuote{lerw}. Note that the method based on
Prüfer sequences does not support directed trees at the moment.}
}
\value{
A graph object.
}
\description{
\code{sample_tree()} generates a random with a given number of nodes uniform
at random from the set of labelled trees.
}
\details{
In other words, the function generates each possible labelled tree with the
given number of nodes with the same probability.
}
\examples{

g <- sample_tree(100, method = "lerw")

}
\seealso{
Random graph models (games)
\code{\link{erdos.renyi.game}()},
\code{\link{sample_bipartite}()},
\code{\link{sample_correlated_gnp_pair}()},
\code{\link{sample_correlated_gnp}()},
\code{\link{sample_degseq}()},
\code{\link{sample_dot_product}()},
\code{\link{sample_fitness_pl}()},
\code{\link{sample_fitness}()},
\code{\link{sample_forestfire}()},
\code{\link{sample_gnm}()},
\code{\link{sample_gnp}()},
\code{\link{sample_grg}()},
\code{\link{sample_growing}()},
\code{\link{sample_hierarchical_sbm}()},
\code{\link{sample_islands}()},
\code{\link{sample_k_regular}()},
\code{\link{sample_last_cit}()},
\code{\link{sample_pa_age}()},
\code{\link{sample_pa}()},
\code{\link{sample_pref}()},
\code{\link{sample_sbm}()},
\code{\link{sample_smallworld}()},
\code{\link{sample_traits_callaway}()},
\code{\link{sample_}()}
}
\concept{games}
\keyword{graphs}
