% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/community.R
\name{as_membership}
\alias{as_membership}
\title{Declare a numeric vector as a membership vector}
\usage{
as_membership(x)
}
\arguments{
\item{x}{The input vector.}
}
\value{
The input vector, with the \code{membership} class added.
}
\description{
This is useful if you want to use functions defined on
membership vectors, but your membership vector does not
come from an igraph clustering method.
}
\examples{
## Compare to the correct clustering
g <- (make_full_graph(10) + make_full_graph(10)) \%>\%
  rewire(each_edge(p = 0.2))
correct <- rep(1:2, each = 10) \%>\% as_membership()
fc <- cluster_fast_greedy(g)
compare(correct, fc)
compare(correct, membership(fc))
}
\seealso{
Community detection
\code{\link{cluster_edge_betweenness}()},
\code{\link{cluster_fast_greedy}()},
\code{\link{cluster_fluid_communities}()},
\code{\link{cluster_infomap}()},
\code{\link{cluster_label_prop}()},
\code{\link{cluster_leading_eigen}()},
\code{\link{cluster_leiden}()},
\code{\link{cluster_louvain}()},
\code{\link{cluster_optimal}()},
\code{\link{cluster_spinglass}()},
\code{\link{cluster_walktrap}()},
\code{\link{compare}()},
\code{\link{groups}()},
\code{\link{make_clusters}()},
\code{\link{membership}()},
\code{\link{modularity.igraph}()},
\code{\link{plot_dendrogram}()},
\code{\link{split_join_distance}()}
}
\concept{community}
