% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/degseq.R
\name{is_degseq}
\alias{is_degseq}
\alias{is.degree.sequence}
\title{Check if a degree sequence is valid for a multi-graph}
\usage{
is_degseq(out.deg, in.deg = NULL)
}
\arguments{
\item{out.deg}{Integer vector, the degree sequence for undirected graphs, or
the out-degree sequence for directed graphs.}

\item{in.deg}{\code{NULL} or an integer vector. For undirected graphs, it
should be \code{NULL}. For directed graphs it specifies the in-degrees.}
}
\value{
A logical scalar.
}
\description{
\code{is_degseq()} checks whether the given vertex degrees (in- and
out-degrees for directed graphs) can be realized by a graph. Note that the
graph does not have to be simple, it may contain loop and multiple edges.
For undirected graphs, it also checks whether the sum of degrees is even.
For directed graphs, the function checks whether the lengths of the two
degree vectors are equal and whether their sums are also equal. These are
known sufficient and necessary conditions for a degree sequence to be valid.
}
\examples{
g <- sample_gnp(100, 2 / 100)
is_degseq(degree(g))
is_graphical(degree(g))
}
\references{
Z Kiraly, Recognizing graphic degree sequences and generating
all realizations. TR-2011-11, Egervary Research Group, H-1117, Budapest,
Hungary. ISSN 1587-4451 (2012).

B. Cloteaux, Is This for Real? Fast Graphicality Testing, \emph{Comput. Sci. Eng.} 17, 91 (2015).

A. Berger, A note on the characterization of digraphic sequences, \emph{Discrete Math.} 314, 38 (2014).

G. Cairns and S. Mendan, Degree Sequence for Graphs with Loops (2013).
}
\seealso{
Other graphical degree sequences: 
\code{\link{is_graphical}()}
}
\author{
Tamas Nepusz \email{ntamas@gmail.com} and Szabolcs Horvat \email{szhorvat@gmail.com}
}
\concept{graphical degree sequences}
\keyword{graphs}
