% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{rglplot}
\alias{rglplot}
\alias{rglplot.igraph}
\title{3D plotting of graphs with OpenGL}
\usage{
rglplot(x, ...)
}
\arguments{
\item{x}{The graph to plot.}

\item{\dots}{Additional arguments, see \link{igraph.plotting} for the
details}
}
\value{
\code{NULL}, invisibly.
}
\description{
Using the \code{rgl} package, \code{rglplot()} plots a graph in 3D. The plot
can be zoomed, rotated, shifted, etc. but the coordinates of the vertices is
fixed.
}
\details{
Note that \code{rglplot()} is considered to be highly experimental. It is not
very useful either. See \link{igraph.plotting} for the possible
arguments.
}
\examples{

g <- make_lattice(c(5, 5, 5))
coords <- layout_with_fr(g, dim = 3)
if (interactive()) {
  rglplot(g, layout = coords)
}

}
\seealso{
\link{igraph.plotting}, \code{\link[=plot.igraph]{plot.igraph()}} for the 2D
version, \code{\link[=tkplot]{tkplot()}} for interactive graph drawing in 2D.

Other plot: 
\code{\link{plot.igraph}()}

Other plot: 
\code{\link{plot.igraph}()}
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\concept{plot}
\keyword{graphs}
