% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.R
\name{make_full_graph}
\alias{make_full_graph}
\alias{graph.full}
\alias{full_graph}
\title{Create a full graph}
\usage{
make_full_graph(n, directed = FALSE, loops = FALSE)

full_graph(...)
}
\arguments{
\item{n}{Number of vertices.}

\item{directed}{Whether to create a directed graph.}

\item{loops}{Whether to add self-loops to the graph.}

\item{...}{Passed to \code{make_full_graph()}.}
}
\value{
An igraph graph
}
\description{
Create a full graph
}
\examples{
make_full_graph(5)
print_all(make_full_graph(4, directed = TRUE))
}
\seealso{
Other deterministic constructors: 
\code{\link{graph_from_atlas}()},
\code{\link{graph_from_edgelist}()},
\code{\link{graph_from_literal}()},
\code{\link{make_chordal_ring}()},
\code{\link{make_empty_graph}()},
\code{\link{make_full_citation_graph}()},
\code{\link{make_graph}()},
\code{\link{make_lattice}()},
\code{\link{make_ring}()},
\code{\link{make_star}()},
\code{\link{make_tree}()}
}
\concept{Full graph}
\concept{deterministic constructors}
