% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/community.R
\name{leading.eigenvector.community}
\alias{leading.eigenvector.community}
\title{Community structure detecting based on the leading eigenvector of the community matrix}
\usage{
leading.eigenvector.community(
  graph,
  steps = -1,
  weights = NULL,
  start = NULL,
  options = arpack_defaults(),
  callback = NULL,
  extra = NULL,
  env = parent.frame()
)
}
\arguments{
\item{graph}{The input graph. Should be undirected as the method needs a
symmetric matrix.}

\item{steps}{The number of steps to take, this is actually the number of
tries to make a step. It is not a particularly useful parameter.}

\item{weights}{The weights of the edges. It must be a positive numeric vector,
\code{NULL} or \code{NA}. If it is \code{NULL} and the input graph has a
\sQuote{weight} edge attribute, then that attribute will be used. If
\code{NULL} and no such attribute is present, then the edges will have equal
weights. Set this to \code{NA} if the graph was a \sQuote{weight} edge
attribute, but you don't want to use it for community detection. A larger
edge weight means a stronger connection for this function.}

\item{start}{\code{NULL}, or a numeric membership vector, giving the start
configuration of the algorithm.}

\item{options}{A named list to override some ARPACK options.}

\item{callback}{If not \code{NULL}, then it must be callback function. This
is called after each iteration, after calculating the leading eigenvector of
the modularity matrix. See details below.}

\item{extra}{Additional argument to supply to the callback function.}

\item{env}{The environment in which the callback function is evaluated.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\code{leading.eigenvector.community()} was renamed to \code{\link[=cluster_leading_eigen]{cluster_leading_eigen()}} to create a more
consistent API.
}
\keyword{internal}
