% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.R
\name{realize_bipartite_degseq}
\alias{realize_bipartite_degseq}
\title{Creating a bipartite graph from two degree sequences, deterministically}
\usage{
realize_bipartite_degseq(
  degrees1,
  degrees2,
  ...,
  allowed.edge.types = c("simple", "multiple"),
  method = c("smallest", "largest", "index")
)
}
\arguments{
\item{degrees1}{The degrees of the first partition.}

\item{degrees2}{The degrees of the second partition.}

\item{...}{These dots are for future extensions and must be empty.}

\item{allowed.edge.types}{Character, specifies the types of allowed edges.
\dQuote{simple} allows simple graphs only (no multiple edges).
\dQuote{multiple} allows multiple edges.}

\item{method}{Character, the method for generating the graph; see below.}
}
\value{
The new graph object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Constructs a bipartite graph from the degree sequences of its partitions,
if one exists. This function uses a Havel-Hakimi style construction
algorithm.
}
\details{
The \sQuote{method} argument controls in which order the vertices are
selected during the course of the algorithm.

The \dQuote{smallest} method selects the vertex with the smallest remaining
degree, from either partition. The result is usually a graph with high
negative degree assortativity. In the undirected case, this method is
guaranteed to generate a connected graph, regardless of whether multi-edges
are allowed, provided that a connected realization exists. This is the
default method.

The \dQuote{largest} method selects the vertex with the largest remaining
degree. The result is usually a graph with high positive degree
assortativity, and is often disconnected.

The \dQuote{index} method selects the vertices in order of their index.
}
\examples{
g <- realize_bipartite_degseq(c(3, 3, 2, 1, 1), c(2, 2, 2, 2, 2))
degree(g)
}
\seealso{
\code{\link[=realize_degseq]{realize_degseq()}} to create a not necessarily bipartite graph.
}
\keyword{graphs}
\section{Related documentation in the C library}{\href{https://igraph.org/c/html/0.10.17/igraph-Generators.html#igraph_realize_bipartite_degree_sequence}{\code{realize_bipartite_degree_sequence()}}.}

