% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\docType{methods}
\name{add_col_summary}
\alias{add_col_summary}
\alias{add_col_summary,Iheatmap-method}
\title{add_col_summary}
\usage{
\S4method{add_col_summary}{Iheatmap}(p, groups = NULL,
  heatmap_name = NULL, colors = NULL, tracename = "Col Summary",
  showlegend = FALSE, side = c("top", "bottom"), layout = list(),
  size = 0.3, buffer = 0.02, xname = current_xaxis(p),
  yname = NULL, type = c("scatter", "bar"),
  summary_function = c("mean", "median", "sd", "var", "mad", "max",
  "min", "sum"), ...)
}
\arguments{
\item{p}{\code{\link{Iheatmap-class}} object}

\item{groups}{vector of group labels, name of groups colorbar, or TRUE -- 
see Details}

\item{heatmap_name}{name of a heatmap within the plot}

\item{colors}{vector of colors or RColorBrewer palette name}

\item{tracename}{name of trace}

\item{showlegend}{show legend?}

\item{side}{side of plot on which to add subplot}

\item{layout}{xaxis layout list}

\item{size}{relative size of subplot relative to main heatmap}

\item{buffer}{amount of space to leave empty before this plot, relative to 
size of first heatmap}

\item{xname}{internal name of xaxis}

\item{yname}{internal name of yaxis}

\item{type}{scatter or bar?}

\item{summary_function}{summary function to use, default is mean, options 
are mean, median, sd, var, mad, max, min, and sum}

\item{...}{additional arguments to \code{\link{add_col_plot}} or 
\code{\link{add_col_barplot}}}
}
\value{
\code{\link{Iheatmap-class}} object, which can be printed to generate 
an interactive graphic
}
\description{
Adds a line plot summarizing the values across columns
}
\details{
If adding the column summary to a vertically oriented heatmap, the summary 
will be based on the topmost heatmap if side is "top" and based on the bottom
heatmap if side is "bottom" unless a "heatmap_name" is specified. The 
heatmap_name should match the "pname" argument given to a previously added
heatmap.

The column summary is based on specific rows if a "groups" argument
is given. The groups argument can either be a vector of group assignments for 
each row, the "pname" for an existing set of groups incorporated into the 
plot using \code{\link{add_row_groups}}, \code{\link{add_row_annotation}}, 
\code{\link{add_row_clusters}}, or \code{\link{add_row_clustering}}.  If 
groups is set to TRUE, then the function will use an existing set of row 
groups added to the plot.
}
\examples{

mat <- matrix(rnorm(20), ncol = 5, nrow = 4)  
hm1 <- iheatmap(mat) \%>\% add_col_summary()
hm2 <- iheatmap(mat) \%>\% add_col_summary(groups = c("A","A","B","B"))

# Print heatmap if interactive session 
if (interactive()) hm1
if (interactive()) hm2
}
\seealso{
\code{\link{add_row_summary}}, \code{\link{iheatmap}}, 
\code{\link{add_col_plot}}
}
\author{
Alicia Schep
}
