% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_heatmap.R
\docType{methods}
\name{add_main_heatmap}
\alias{add_main_heatmap}
\alias{add_main_heatmap,IheatmapHorizontal,matrix-method}
\alias{add_main_heatmap,IheatmapVertical,matrix-method}
\title{add_main_heatmap}
\usage{
\S4method{add_main_heatmap}{IheatmapHorizontal,matrix}(p, data,
  name = "Signal", x = default_x(data),
  colors = pick_continuous_colors(zmid, zmin, zmax, p),
  colorbar_position = get_colorbar_position(p), show_colorbar = TRUE,
  zmin = min(data, na.rm = TRUE), zmax = max(data, na.rm = TRUE),
  zmid = 0, col_order = NULL, x_categorical = NULL,
  side = c("right", "left"), size = 1, buffer = 0.04,
  text = signif(data, digits = 3), tooltip = setup_tooltip_options(),
  xname = NULL, pname = name, ...)

\S4method{add_main_heatmap}{IheatmapVertical,matrix}(p, data,
  name = "Signal", y = default_y(data),
  colors = pick_continuous_colors(zmid, zmin, zmax, p),
  colorbar_position = get_colorbar_position(p), show_colorbar = TRUE,
  zmin = min(data, na.rm = TRUE), zmax = max(data, na.rm = TRUE),
  zmid = 0, row_order = NULL, y_categorical = NULL,
  side = c("bottom", "top"), size = 1, buffer = 0.04,
  text = signif(data, digits = 3), tooltip = setup_tooltip_options(),
  yname = NULL, pname = name, ...)
}
\arguments{
\item{p}{\code{\link{Iheatmap-class}} object}

\item{data}{matrix}

\item{name}{name of colorbar, will determine if colorbar is shared with 
existing plot}

\item{x}{x axis labels (by default rownames of data); only used if 
orientation is horizontal}

\item{colors}{color palette name or vector of colors}

\item{colorbar_position}{colorbar placement}

\item{show_colorbar}{display the colorbar?}

\item{zmin}{minimum for colorscale}

\item{zmax}{maximum for colorscale}

\item{zmid}{midpoint for scale}

\item{col_order}{column ordering for this heatmap; only used if orientation 
is horizontal}

\item{x_categorical}{is x categorical?  will guess if not provided}

\item{side}{which side of the current plot to add this heatmap?}

\item{size}{relative size of plot.  size relative to first heatmap}

\item{buffer}{amount of space to leave empty before this plot, relative to 
size of first heatmap}

\item{text}{text of value to display for data}

\item{tooltip}{tooltip options, see \code{\link{setup_tooltip_options}}}

\item{xname}{internal name for x axis}

\item{pname}{internal name for plot}

\item{...}{additional arguments (ignored)}

\item{y}{y axis labels (by default colnames of data); only used if 
orientation is vertical}

\item{row_order}{row ordering for this heatmap; only used if orientation is 
vertical}

\item{y_categorical}{is y categorical?  will guess if not provided}

\item{yname}{internal name for y axis}
}
\value{
\code{\link{Iheatmap-class}} object, which can be printed to generate 
an interactive graphic
}
\description{
Adds an additional main heatmap to an iheatmap object
}
\examples{

mat <- matrix(rnorm(20), ncol = 5, nrow = 4) 
mat2 <-  matrix(rnorm(24), ncol = 6, nrow = 4) 
hm <- iheatmap(mat) \%>\% add_main_heatmap(mat2)

# Print heatmap if interactive session 
if (interactive()) hm 
}
\seealso{
\code{\link{iheatmap}}, \code{\link{main_heatmap}}
}
\author{
Alicia Schep
}
