% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{logitCdaC}
\alias{logitCdaC}
\title{Optimize a logistic regression model by coordinate descent algorithm using a design matrix}
\usage{
logitCdaC(X_tilde, y, lambda, R, init_beta, delta = 0, maxit = 10000,
  eps = 1e-04, warm = "lambda", strong = TRUE)
}
\arguments{
\item{X_tilde}{standardized matrix of explanatory variables}

\item{y}{vector of objective variable}

\item{lambda}{lambda sequence}

\item{R}{matrix using exclusive penalty term}

\item{init_beta}{initial values of beta}

\item{delta}{ratio of regularization between l1 and exclusive penalty terms}

\item{maxit}{max iteration}

\item{eps}{convergence threshold for optimization}

\item{warm}{warm start direction: "lambda" (default) or "delta"}

\item{strong}{whether use strong screening or not}
}
\value{
standardized beta
}
\description{
Optimize a logistic regression model by coordinate descent algorithm using a design matrix
}
\keyword{internal}
