% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_constructors.R
\name{ijtiff_img}
\alias{ijtiff_img}
\title{\code{ijtiff_img} class.}
\usage{
ijtiff_img(img, ...)
}
\arguments{
\item{img}{An array representing the image. \itemize{\item For a
single-plane, grayscale image, use a matrix \code{img[y, x]}. \item For a
multi-plane, grayscale image, use a 3-dimensional array \code{img[y, x, plane]}.
\item For a multi-channel, single-plane image, use a 4-dimensional array
with a redundant 4th slot \code{img[y, x, channel, ]} (see \link{ijtiff_img}
'Examples' for an example). \item For a multi-channel, multi-plane image,
use a 4-dimensional array \code{img[y, x, channel, plane]}.}}

\item{...}{Named arguments which are set as attributes.}
}
\value{
A 4 dimensional array representing an image, indexed by \code{img[y, x, channel, frame]} (this is consistent with the \code{EBImage} package
(\url{https://bioconductor.org/packages/EBImage/})) with selected
attributes.
}
\description{
A class for images which are read or to be written by the \code{ijtiff} package.
}
\examples{
img <- matrix(1:4, nrow = 2)  # to be a single-channel, grayscale image
ijtiff_img(img, description = "single-channel, grayscale")
img <- array(seq_len(2 ^ 3), dim = rep(2, 3))  # 1 channel, 2 frame
ijtiff_img(img, description = "blah blah blah")
img <- array(seq_len(2 ^ 3), dim = c(2, 2, 2, 1))  #  2 channel, 1 frame
ijtiff_img(img, description = "blah blah")
img <- array(seq_len(2 ^ 4), dim = rep(2, 4))  # 2 channel, 2 frame
ijtiff_img(img, software = "R")
}
