% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{linescan-conversion}
\alias{linescan-conversion}
\alias{linescan_to_stack}
\alias{stack_to_linescan}
\title{Rejig linescan images.}
\usage{
linescan_to_stack(linescan_img)

stack_to_linescan(img)
}
\arguments{
\item{linescan_img}{A 4-dimensional array in which the time axis is the first
axis. Dimension 4 must be 1 i.e. \code{dim(linescan_img)[4] == 1}.}

\item{img}{A conventional \link{ijtiff_img}, to be turned into a linescan image.
Dimension 1 must be 1 i.e. \code{dim(img)[1] == 1}.}
}
\value{
The converted image, an object of class \link{ijtiff_img}.
}
\description{
\code{ijtiff} has the fourth dimension of an \link{ijtiff_img} as its time dimension.
However, some linescan images (images where a single line of pixels is
acquired over and over) have the time dimension as the y dimension, (to avoid
the need for an image stack). These functions allow one to convert this type
of image into a conventional \link{ijtiff_img} (with time in the fourth dimension)
and to convert back.
}
\examples{
linescan <- ijtiff_img(array(rep(1:4, each = 4), dim = c(4, 4, 1, 1)))
print(linescan)
stack <- linescan_to_stack(linescan)
print(stack)
linescan <- stack_to_linescan(stack)
print(linescan)

}
