% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symmetry.R
\name{img_symmetry}
\alias{img_symmetry}
\title{Image symmetry}
\usage{
img_symmetry(img, vertical = TRUE, horizontal = TRUE, ...)
}
\arguments{
\item{img}{An image in form of a matrix or array of numeric values. Use e.g.
\code{\link{img_read}()} to read an image file into \code{R}.}

\item{vertical}{logical. Should the vertical symmetry be computed? (default:
TRUE)}

\item{horizontal}{logical. Should the horizontal symmetry be computed?
(default: TRUE)}

\item{...}{Further options: \code{shift_range} to shift the mirror axis,
\code{per_channel} to switch between a maximal per channel vs. per image
symmetry (see details).}
}
\value{
a named vector of numeric values (vertical and horizontal symmetry)
}
\description{
\code{img_symmetry} returns the vertical and horizontal mirror symmetry of an
image. Higher values indicate higher image symmetry.
}
\details{
The function returns the vertical and horizontal mirror symmetry of
  an image \code{img}. Symmetry values can range between 0 (not symmmetrical)
  and 1 (fully symmetrical). If \code{vertical} or \code{horizontal} is set
  to \code{FALSE} then vertical or horizontal symmetry is not computed,
  respectively.

  As the perceptual mirror axis is not necessarily exactly in the middle of a
  picture, the function estimates in a first step several symmetry values
  with different positions for the mirror axis. To this end, the mirror axis
  is automatically shifted up to 5\% (default) of the image width to the left
  and to the right (in the case of vertical symmetry; analogously for
  horizontal symmetry). In the second step, the overall symmetry score is
  computed as the maximum of the symmetry scores given the different mirror
  axes. See Mayer & Landwehr (2018) for details.

  Advanced users can change the shift range with the optional parameter
  \code{shift_range}, which takes a numeric decimal as input. The default
  \code{shift_range = 0.05} (i.e., 5\%).

  For color images, the default is that first a maximal symmetry score (as
  explained above) is obtained per color channel (parameter \code{per_channel
  = TRUE}). Subsequently, a weighted average between each color channel's
  maximal score is computed as the image's overall symmetry. Advanced users
  can reverse this order by setting \code{per_channel = FALSE}. This results
  in first computing the weighted averages for each position of the mirror
  axis seperately, and afterwards finding the maximal overall symmetry score.
}
\examples{
# Example image with high vertical symmetry: rails
rails <- img_read(system.file("example_images", "rails.jpg", package = "imagefluency"))
#
# display image
grid::grid.raster(rails)
#
# get symmetry
img_symmetry(rails)

# Example image with low vertical symmetry: bridge
bridge <- img_read(system.file("example_images", "bridge.jpg", package = "imagefluency"))
#
# display image
grid::grid.raster(bridge)
#
# get symmetry
img_symmetry(bridge)

}
\references{
Mayer, S. & Landwehr, J, R. (2018). Quantifying Visual Aesthetics
  Based on Processing Fluency Theory: Four Algorithmic Measures for
  Antecedents of Aesthetic Preferences. \emph{Psychology of Aesthetics,
  Creativity, and the Arts}, \emph{12}(4), 399--431.
  doi:\href{https://doi.org/10.1037/aca0000187}{10.1037/aca0000187}
}
\seealso{
\code{\link{img_read}}, \code{\link{img_complexity}},
  \code{\link{img_contrast}}, \code{\link{img_self_similarity}}
  \code{\link{img_simplicity}}, \code{\link{img_typicality}}
}
