% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imgen.R
\name{as.cimg.function}
\alias{as.cimg.function}
\title{Create an image by sampling a function}
\usage{
\method{as.cimg}{`function`}(
  obj,
  width,
  height,
  depth = 1,
  spectrum = 1,
  standardise = FALSE,
  dim = NULL,
  ...
)
}
\arguments{
\item{obj}{a function with arguments (x,y), or (x,y,cc), or (x,y,z), etc. Must be vectorised; see examples.}

\item{width}{width of the image (in pixels)}

\item{height}{height of the image (in pixels)}

\item{depth}{depth of the image (in pixels). Default 1.}

\item{spectrum}{number of colour channels. Defaut 1.}

\item{standardise}{coordinates are scaled and centered (see doc for pixel.grid)}

\item{dim}{a vector of image dimensions (can be used instead of width, height, etc.)}

\item{...}{ignored}
}
\value{
an object of class cimg
}
\description{
Similar to as.im.function from the spatstat package, but simpler. Creates a grid of pixel coordinates x=1:width,y=1:height and (optional) z=1:depth, and evaluates the input function at these values.
}
\examples{
\dontshow{cimg.limit.openmp()}
im = as.cimg(function(x,y) cos(sin(x*y/100)),100,100)
plot(im)
#The following is just a rectangle at the center of the image 
im = as.cimg(function(x,y) (abs(x) < .1)*(abs(y) < .1) ,100,100,standardise=TRUE)
plot(im)
#Since coordinates are standardised the rectangle scales with the size of the image
im = as.cimg(function(x,y) (abs(x) < .1)*(abs(y) < .1) ,200,200,standardise=TRUE)
plot(im)
#A Gaussian mask around the center
im = as.cimg(function(x,y) dnorm(x,sd=.1)*dnorm(y,sd=.3) ,dim=dim(boats),standardise=TRUE)
im = im/max(im)

plot(im*boats)
#A Gaussian mask for just the red channel
fun = function(x,y,cc) ifelse(cc==1,dnorm(x,sd=.1)*dnorm(y,sd=.3),0)
im = as.cimg(fun,dim=dim(boats),standardise=TRUE)
plot(im*boats)

}
\author{
Simon Barthelme
}
