% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loading.R
\name{load.dir}
\alias{load.dir}
\title{Load all images in a directory}
\usage{
load.dir(path, pattern = NULL, quiet = FALSE)
}
\arguments{
\item{path}{directory to load from}

\item{pattern}{optional: file pattern (ex. *jpg). Default NULL, in which case we look for file extensions png,jpeg,jpg,tif,bmp.}

\item{quiet}{if TRUE, loading errors are quiet. If FALSE, they are displayed. Default FALSE}
}
\value{
an image list
}
\description{
Load all images in a directory and return them as an image list.
}
\examples{
\dontshow{cimg.limit.openmp()}
path <- system.file(package="imager") \%>\% paste0("/extdata")
load.dir(path)
}
\author{
Simon Barthelme
}
