% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_json.R
\name{save_json}
\alias{save_json}
\title{ave annotation data as JSON}
\usage{
save_json(annotations, file)
}
\arguments{
\item{annotations}{An annotation object created with \code{\link[imgrec]{get_annotations}}.}

\item{file}{Local path where the JSON data should be stored.}
}
\value{
nothing.
}
\description{
Writes raw JSON data as returned by the Google Vision API to a UTF-8 encoded local file.
}
\examples{
\dontrun{
 gvision_init()

 finn_image <- 'https://upload.wikimedia.org/wikipedia/en/2/2a/Finn-Force_Awakens_\%282015\%29.png'
 results <- get_annotations(images = finn_image, features = 'all',
                            max_res = 10, mode = 'url')
 temp_file_path <- tempfile(fileext = '.json')
 save_json(results, temp_file_path)
  }
}
