% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_import_funs.R
\name{get_country_cocirculation_data}
\alias{get_country_cocirculation_data}
\title{Get data on the relative circulation of each influenza A subtype}
\usage{
get_country_cocirculation_data(
  country,
  max_year,
  min_samples = 30,
  output_format = "tibble"
)
}
\arguments{
\item{country}{country of interest. Run \code{show_available_countries()} for a list of valid inputs.}

\item{max_year}{last year of interest. Results will be generated from 1918:max_year.}

\item{min_samples}{if fewer than \code{min_samples} (default 30) are reported in the country and year of interest, the function will substitute data from the corresponding WHO region.}

\item{output_format}{can be 'tibble' (the default) or 'matrix' (used mainly for convenience within other functions)}
}
\value{
A matrix with rows showing the calendar year, the fraction of influenza A-positive specimens of each subtype (rows \code{A/H1N1}, \code{A/H2N2}, and \code{A/H3N2}), and of each HA group (rows \verb{group 1}, and \verb{group 2}). Row \code{A} should always be 1, as it shows the sum of subtype-specific fractions. Row \code{B} is a placeholder whose values are all \code{NA}.
}
\description{
\code{get_country_cocirculation_data()} imports data on the fraction of influenza A cases in a specific country and year that were caused by each influenza A subtype (H1N1, H2N2, or H3N2), or group (group 1 or group 2). Group 1 contains H1N1 and H2N2, and group 2 contains H2N2.
}
\details{
The data come from three sources:
\itemize{
\item Historical assumptions: From 1918-1956, we assume only H1N1 circulated. From 1957-1967, we assume only H2N2 circulated. From 1968-1976, we assume only H3N2 circulated.
\item \href{https://jamanetwork.com/journals/jama/fullarticle/195750}{Thompson et al. JAMA, 2003}: From 1977-1996 we pull data on the relative dominance of H1N1 and H3N2 from Table 1 of Thompson et al. 2003, which reports surveillance data collected in the United States.
\item From 1997-present, we pull in country or region-specific data from \href{https://apps.who.int/flumart/Default?ReportNo=12}{WHO Flu Mart} on the fraction of specimens collected in routine influenza surveillance that test positive for each subtype. Country-specific data are the default. Regional data, then global data are used if the number of country or region-specific specimens is insufficient. \code{\link[=get_template_data]{get_template_data()}} imports the data for 1918-1996. \code{\link[=get_country_inputs_1997_to_present]{get_country_inputs_1997_to_present()}} and \code{\link[=get_regional_inputs_1997_to_present]{get_regional_inputs_1997_to_present()}} import the data for 1997 on.
}
}
\examples{
get_country_cocirculation_data("United States", "2019")
get_country_cocirculation_data("Laos", "2022", min_samples = 40)

}
\seealso{
\doi{https://doi.org/10.1126/science.aag1322}{Gostic et al. Science, (2016)} for detailed methods.
}
