% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/na.replace.R
\name{na.replace}
\alias{na.replace}
\title{Missing Value Imputation by Defined Value}
\usage{
na.replace(data, fill = 0, na.identifier = NA)
}
\arguments{
\item{data}{Time Series (\code{\link{ts}}) object in which missing values are to be replaced}

\item{fill}{Value used to replace the missing values}

\item{na.identifier}{Missing Value Identifier.
If another value than NA indicates missing values this can be specified here.
Identifier can be a character string as well as a numeric value.}
}
\value{
Time Series (\code{\link{ts}}) object
}
\description{
Replaces all missing values with a given value.
}
\examples{
#Create Time series with missing values
x <- ts(c(2,3,NA,5,6,NA,7,8))

#Replace all NAs with 3.5
na.replace(x, fill = 3.5 )
}
\author{
Steffen Moritz
}
\seealso{
\code{\link[imputeTS]{na.mean}}, \code{\link[imputeTS]{na.locf}},
 \code{\link[imputeTS]{na.random}}, \code{\link[imputeTS]{na.replace}}
}

