% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotNA.distribution.R
\name{plotNA.distribution}
\alias{plotNA.distribution}
\title{Visualize Distribution of Missing Values}
\usage{
plotNA.distribution(x, colPoints = "steelblue",
  colBackgroundMV = "indianred2", main = "Distribution of NAs",
  xlab = "Time", ylab = "Value", pch = 20, cexPoints = 0.8,
  col = "black", ...)
}
\arguments{
\item{x}{Numeric Vector (\code{\link{vector}}) or Time Series (\code{\link{ts}}) object containing NAs}

\item{colPoints}{Color of the points for each observation}

\item{colBackgroundMV}{Color for the background for the NA sequences}

\item{main}{Main label for the plot}

\item{xlab}{Label for x axis of the plot}

\item{ylab}{Label for y axis of plot}

\item{pch}{Plotting 'character', i.e., symbol to use.}

\item{cexPoints}{character (or symbol) expansion: a numerical vector.}

\item{col}{Color for the lines.}

\item{...}{Additional graphical parameters that can be passed through to plot}
}
\description{
Visualize the distribution of missing values within a time series.
}
\details{
This function visualizes the distribution of missing values within a time series. Therefore
the time series is plotted and whenever a value is NA the background is colored differently.
This gives a nice overview, where in the time series most of the missing values occur.
}
\examples{
#Prerequisite: Load a time series with missing values
x <- tsAirgap

#Example 1: Visualize the missing values in this time series
plotNA.distribution(x)

}
\author{
Steffen Moritz
}
\seealso{
\code{\link[imputeTS]{plotNA.distributionBar}},
 \code{\link[imputeTS]{plotNA.gapsize}}, \code{\link[imputeTS]{plotNA.imputations}}
}

