% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_names.R
\name{group_names}
\alias{group_names}
\alias{group_names<-}
\alias{group_names.default}
\alias{group_names<-.default}
\alias{`group_names<-`.default}
\alias{group_names.incidence}
\alias{group_names<-.incidence}
\title{extract and set group names}
\usage{
group_names(x, value)

group_names(x) <- value

\method{group_names}{default}(x, value)

\method{group_names}{default}(x) <- value

\method{group_names}{incidence}(x, value = NULL)

\method{group_names}{incidence}(x) <- value
}
\arguments{
\item{x}{an \code{\link[=incidence]{incidence()}} object.}

\item{value}{character vector used to rename groups}
}
\value{
an integer indicating the number of groups present in the incidence
object.
}
\description{
extract and set group names
}
\details{
This accessor will return a
}
\examples{
i <- incidence(dates = sample(10, 100, replace = TRUE), 
               interval = 1L,
               groups = sample(letters[1:3], 100, replace = TRUE))
i
group_names(i)

# change the names of the groups
group_names(i) <- c("Group 1", "Group 2", "Group 3")
i

# example if there are mistakes in the original data, e.g. 
# something is misspelled
set.seed(50)
grps <- sample(c("child", "adult", "adlut"), 100, replace = TRUE, prob = c(0.45, 0.45, 0.05))
i <- incidence(dates = sample(10, 100, replace = TRUE), 
               interval = 1L,
               groups = grps)
colSums(get_counts(i))

# If you change the name of the mis-spelled group, it will be merged with the
# correctly-spelled group
gname <- group_names(i)
gname[gname == "adlut"] <- "adult"
# without side-effects
print(ii <- group_names(i, gname))
colSums(get_counts(i))  # original still has three groups
colSums(get_counts(ii))
# with side-effects
group_names(i) <- gname
colSums(get_counts(i))
}
\keyword{accessors}
