% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nest.R
\name{nest.incidence2}
\alias{nest.incidence2}
\title{Nest rows into a list-column of data frames}
\usage{
\method{nest}{incidence2}(.data, ..., .by, .key, .names_sep)
}
\arguments{
\item{.data}{An \link[=incidence]{incidence2} object.}

\item{...}{Not used.}

\item{.by}{Not used.}

\item{.key}{The name of the resulting nested column. Only applicable when
\code{...} isn't specified, i.e. in the case of \code{df \%>\% nest(.by = x)}.

If \code{NULL}, then \code{"data"} will be used by default.}

\item{.names_sep}{Not used.}
}
\value{
A nested \link[tibble:tibble]{tibble} with rows corresponding to the count
variable and (optionally) group columns of the input object.
}
\description{
Method for \link[tidyr:nest]{tidyr::nest} that implicitly accounts for the inherent
grouping structure of incidence2 objects.
}
\examples{
\dontshow{.old <- data.table::setDTthreads(2)}
if (requireNamespace("outbreaks", quietly = TRUE)) {
    data(ebola_sim_clean, package = "outbreaks")
    ebola_sim_clean$linelist |>
        subset(!is.na(hospital)) |>
        incidence_(date_of_onset, hospital, interval = "isoweek") |>
        nest()
}
\dontshow{data.table::setDTthreads(.old)}

}
\seealso{
\link[tidyr:nest]{tidyr::nest} for the underlying generic.
}
