% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delay_estimation.R
\name{objFunFactory}
\alias{objFunFactory}
\title{Factory method for objective function, either according to maximum product of spacings estimation ('MPSE')
or according to standard maximum likelihood estimation ('MLE0').}
\usage{
objFunFactory(
  x,
  y = NULL,
  method = c("MPSE", "MLE0"),
  distribution = c("exponential", "weibull"),
  bind = NULL,
  ties = c("density", "equidist", "random", "error"),
  verbose = 0L
)
}
\arguments{
\item{x}{numeric. observations}

\item{y}{numeric. observations in second group.}

\item{method}{character(1). Specifies the method for which to build the objective function. Default value is \code{MPSE}. \code{MLE0} is the standard MLE-method, calculating the likelihood function as the product of density values}

\item{distribution}{character(1). delayed distribution family}

\item{bind}{character. parameter names that are bind together (i.e. equated) between both groups}

\item{ties}{character. How to handle ties within data of a group.}

\item{verbose}{integer flag. How much verbosity in output? The higher the more output. Default value is 0 which is no output.}
}
\value{
the objective function (e.g., the negative MPSE criterion) for given choice of model parameters or \code{NULL} upon errors
}
\description{
Given the observed data this factory method produces an MPSE objective function implementation
which is the negative of the MPSE-criterion H or the negative log-likelihood for MLE.
}
\details{
From the observations, negative or infinite values are discarded. In any case, the objective function is to be minimized.
}
