% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{.calc.taustar}
\alias{.calc.taustar}
\alias{calc.taustar}
\title{Compute the Tau* statistic}
\usage{
.calc.taustar(perm)
}
\arguments{
\item{perm}{An integer vector containing exactly 0,1,...,n-1 in any order.

    The validity of the input is not checked by this function.}
}
\value{
The Tau* statistic of \code{perm}.

    The normalization is such that \emph{-1/3 <= Tau* <= 2/3}.

    The return value -1.0 indicates an error.
}
\description{
This is an internal CPP function, used by the R function
\code{\link{tau.star.test}}.
}
\details{
Given (X1,Y1),...,(Xn,Yn), the Tau*_n statistic only depends on the
permutation P that satisfies rank Yi = P[rank Xi].
This function computes Tau*_n given P in O(n log n) time.
}
\examples{

.calc.taustar(0:3)
## [1] 0.6666667

.calc.taustar(c(0,2,1,3))
## [1] -0.3333333

set.seed(397)
.calc.taustar(order(runif(1000))-1)
## [1] 0.004392385

}
