% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elicit_functions.R
\name{saveRecord}
\alias{saveRecord}
\title{Function to save elicitation record.}
\usage{
saveRecord(designLink.obj,
  conclusion.comments = "This concludes the elicitation record.", file = "")
}
\arguments{
\item{designLink.obj}{list object initally created by function \code{designLink()} 
and subsequently updated by function \code{elicitPt()}}

\item{conclusion.comments}{character, comments to conclude session. Beware of
non-ASCII text and special characters, which may affect ability to save and
render the likes of Sweave, knitr, markdown, etc.}

\item{file}{character providing filename.}
}
\value{
an RDS file is created with filename \code{file}. A timestamp is
  added to \code{designLink.obj} using \code{Sys.time()}.
}
\description{
Function to save elicitation record.
}
\examples{
\dontrun{
X <- matrix(c(1, 1, 0, 1), nrow = 2) # design
Z <- designLink(design = X)
tmp <- tempfile(pattern = "report", fileext =".rds")
saveRecord(Z, file = tmp)
}
}
