% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/infer-mcnemar-test.R
\name{infer_mcnemar_test}
\alias{infer_mcnemar_test}
\alias{mcnemar_test}
\title{McNemar Test}
\usage{
infer_mcnemar_test(data, x = NULL, y = NULL)
}
\arguments{
\item{data}{a \code{data.frame} or \code{tibble}}

\item{x}{factor; column in \code{data}}

\item{y}{factor; column in \code{data}}
}
\value{
\code{infer_mcnemar_test} returns an object of class \code{"infer_mcnemar_test"}.
An object of class \code{"infer_mcnemar_test"} is a list containing the
following components:

\item{statistic}{chi square statistic}
\item{df}{degrees of freedom}
\item{pvalue}{p-value}
\item{exactp}{exact p-value}
\item{cstat}{continuity correction chi square statistic}
\item{cpvalue}{continuity correction p-value}
\item{kappa}{kappa coefficient; measure of interrater agreement}
\item{std_err}{asymptotic standard error}
\item{kappa_cil}{95\% kappa lower confidence limit}
\item{kappa_ciu}{95\% kappa upper confidence limit}
\item{cases}{cases}
\item{controls}{controls}
\item{ratio}{ratio of proportion with factor}
\item{odratio}{odds ratio}
\item{tbl}{two way table}
}
\description{
Test if the proportions of two dichotomous variables are
equal in the same population.
}
\section{Deprecated Function}{

\code{mcnermar_test()} has been deprecated. Instead use
\code{infer_mcnemar_test()}.
}

\examples{
# using variables from data
library(dplyr)
hb <- mutate(hsb,
        himath = if_else(math > 60, 1, 0),
        hiread = if_else(read > 60, 1, 0)
    )
infer_mcnemar_test(hb, himath, hiread)

# test if the proportion of students in himath and hiread group is same
himath <- ifelse(hsb$math > 60, 1, 0)
hiread <- ifelse(hsb$read > 60, 1, 0)
infer_mcnemar_test(table(himath, hiread))

# using matrix
infer_mcnemar_test(matrix(c(135, 18, 21, 26), nrow = 2))
}
\references{
Sheskin, D. J. 2007. Handbook of Parametric and Nonparametric
Statistical Procedures, 4th edition. : Chapman & Hall/CRC.
}
\seealso{
\code{\link[stats]{mcnemar.test}}
}
