% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{diff_data.assembly}
\alias{diff_data.assembly}
\alias{DDA}
\title{Assembling the differential/regression data}
\usage{
diff_data.assembly(...)
}
\arguments{
\item{...}{Desired datasets/dataframes.}
}
\value{
A dataframe including the collective list of features in rows and all of the
differential/regression data and their statistical significance in columns with the same
order provided by the user.
}
\description{
This function assembles a dataframe required for running the \emph{\strong{\code{ExIR}}} model. You may provide
as many differential/regression data as you wish. Also, the datasets should be filtered
beforehand according to your desired thresholds and, consequently, should only include the significant data.
Each dataset provided should be a dataframe with one or two columns.
The first column should always include differential/regression values
and the second one (if provided) the significance values.
}
\examples{
\dontrun{
my.Diff_data <- diff_data.assembly(Differential_data1,
                                   Differential_data2,
                                   Regression_data1))
}
}
\seealso{
\code{\link[influential]{exir}}
}
\keyword{diff_data.assembly}
