% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{sirir}
\alias{sirir}
\alias{SIRIR}
\title{SIR-based Influence Ranking}
\usage{
sirir(
  graph,
  vertices = V(graph),
  beta = 0.5,
  gamma = 1,
  no.sim = igraph::vcount(graph) * 100,
  seed = 1234
)
}
\arguments{
\item{graph}{A graph (network) of the igraph class.}

\item{vertices}{A vector of desired vertices, which could be obtained by the V function.}

\item{beta}{Non-negative scalar. The rate of infection of an individual that is susceptible
and has a single infected neighbor. The infection rate of a susceptible individual with n
infected neighbors is n times beta. Formally this is the rate parameter of an exponential
distribution.}

\item{gamma}{Positive scalar. The rate of recovery of an infected individual.
Formally, this is the rate parameter of an exponential distribution.}

\item{no.sim}{Integer scalar, the number of simulation runs to perform SIR model on the
original network as well as perturbed networks generated by leave-one-out technique.
You may choose a different no.sim based on the available memory on your system.}

\item{seed}{A single value, interpreted as an integer to be used for random number generation.}
}
\value{
A two-column dataframe; a column containing the difference values of the original and
perturbed networks and a column containing node influence rankings
}
\description{
This function is achieved by the integration susceptible-infected-recovered (SIR) model
with the leave-one-out cross validation technique and ranks network nodes based on their
true universal influence. One of the applications of this function is the assessment of
performance of a novel algorithm in identification of network influential nodes by considering
the SIRIR ranks as the ground truth (gold standard).
}
\examples{
set.seed(1234)
My_graph <- igraph::sample_gnp(n=50, p=0.05)
GraphVertices <- V(My_graph)
Influence.Ranks <- sirir(graph = My_graph, vertices = GraphVertices,
                         beta = 0.5, gamma = 1, no.sim = 10, seed = 1234)
}
\seealso{
\code{\link[influential]{cent_network.vis}},
and \code{\link[igraph]{sir}} for a complete description on SIR model

Other centrality functions: 
\code{\link{betweenness}()},
\code{\link{clusterRank}()},
\code{\link{collective.influence}()},
\code{\link{degree}()},
\code{\link{h_index}()},
\code{\link{lh_index}()},
\code{\link{neighborhood.connectivity}()}
}
\concept{centrality functions}
\keyword{sirir}
