% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partial_dependency.R
\name{partial_dependency}
\alias{partial_dependency}
\alias{partial_dependency.explainer}
\alias{partial_dependency.default}
\alias{partial_dependency.ceteris_paribus_explainer}
\title{Partial Dependency Profiles}
\usage{
partial_dependency(x, ...)

\method{partial_dependency}{explainer}(x, variables = NULL, N = 500,
  variable_splits = NULL, grid_points = 101, ...)

\method{partial_dependency}{default}(x, data, predict_function = predict,
  label = class(x)[1], variables = NULL, grid_points = grid_points,
  variable_splits = variable_splits, N = 500, ...)

\method{partial_dependency}{ceteris_paribus_explainer}(x, ...,
  variables = NULL)
}
\arguments{
\item{x}{a model to be explained, or an explainer created with function `DALEX::explain()` or  object of the class `ceteris_paribus_explainer`.}

\item{...}{other parameters}

\item{variables}{names of variables for which profiles shall be calculated. Will be passed to `calculate_variable_splits()`. If NULL then all variables from the validation data will be used.}

\item{N}{number of observations used for calculation of partial dependency profiles. By default 500.}

\item{variable_splits}{named list of splits for variables, in most cases created with `calculate_variable_splits()`. If NULL then it will be calculated based on validation data avaliable in the `explainer`.}

\item{grid_points}{number of points for profile. Will be passed to `calculate_variable_splits()`.}

\item{data}{validation dataset, will be extracted from `x` if it's an explainer}

\item{predict_function}{predict function, will be extracted from `x` if it's an explainer}

\item{label}{name of the model. By default it's extracted from the 'class' attribute of the model}
}
\value{
an 'aggregated_profiles_explainer' layer
}
\description{
Partial Dependency Profiles are averages from Ceteris Paribus Profiles.
Function 'partial_dependency' calls 'ceteris_paribus' and then 'aggregate_profiles'.
}
\details{
Find more detailes in the \href{https://pbiecek.github.io/PM_VEE/partialDependenceProfiles.html}{Partial Dependence Profiles Chapter}.
}
\examples{
library("DALEX")
# Toy examples, because CRAN angels ask for them
titanic <- na.omit(titanic)
model_titanic_glm <- glm(survived == "yes" ~ gender + age + fare,
                       data = titanic, family = "binomial")

explain_titanic_glm <- explain(model_titanic_glm,
                           data = titanic[,-9],
                           y = titanic$survived == "yes")

pdp_rf <- partial_dependency(explain_titanic_glm, N = 50)
plot(pdp_rf)

\donttest{
 library("randomForest")
 model_titanic_rf <- randomForest(survived ~ gender + age + class + embarked +
                                    fare + sibsp + parch,  data = titanic)
 model_titanic_rf

 explain_titanic_rf <- explain(model_titanic_rf,
                           data = titanic[,-9],
                           y = titanic$survived,
                           label = "Random Forest v7")

pdp_rf <- partial_dependency(explain_titanic_rf, variables = "age")
plot(pdp_rf)

pdp_rf <- partial_dependency(explain_titanic_rf)
plot(pdp_rf)
}
}
\references{
Predictive Models: Visual Exploration, Explanation and Debugging \url{https://pbiecek.github.io/PM_VEE}
}
