% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_aggregated_ceteris_paribus_explainer.R
\name{print.aggregated_ceteris_paribus_explainer}
\alias{print.aggregated_ceteris_paribus_explainer}
\title{Prints Aggregated Profiles}
\usage{
\method{print}{aggregated_ceteris_paribus_explainer}(x, ...)
}
\arguments{
\item{x}{an individual variable profile explainer produced with the `aggregate_profiles()` function}

\item{...}{other arguments that will be passed to `head()`}
}
\description{
Prints Aggregated Profiles
}
\examples{
library("DALEX")
# Toy examples, because CRAN angels ask for them
titanic <- na.omit(titanic)
model_titanic_glm <- glm(survived == "yes" ~ gender + age + fare,
                       data = titanic, family = "binomial")

explain_titanic_glm <- explain(model_titanic_glm,
                           data = titanic[,-9],
                           y = titanic$survived == "yes")
selected_passangers <- select_sample(titanic, n = 100)
cp_rf <- ceteris_paribus(explain_titanic_glm, selected_passangers)
head(cp_rf)
pdp_rf <- aggregate_profiles(cp_rf, variables = "age")
head(pdp_rf)

\donttest{
library("randomForest")
 model_titanic_rf <- randomForest(survived ~ gender + age + class + embarked +
                                    fare + sibsp + parch,  data = titanic)
 model_titanic_rf

 explain_titanic_rf <- explain(model_titanic_rf,
                           data = titanic[,-9],
                           y = titanic$survived)

cp_rf <- ceteris_paribus(explain_titanic_rf, selected_passangers)
cp_rf

pdp_rf <- aggregate_profiles(cp_rf, variables = "age")
head(pdp_rf)

}
}
