% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ini.R
\name{write.ini}
\alias{write.ini}
\title{Write list to .ini file}
\usage{
write.ini(x, filepath, encoding = getOption("encoding"))
}
\arguments{
\item{x}{List with structure to be write at .ini file.}

\item{filepath}{file to write}

\item{encoding}{Encoding of filepath parameter, will default to system
encoding if not specifield}
}
\description{
Write list to .ini file
}
\examples{
## Create a new temp ini for writing
iniFile <- tempfile(fileext = '.ini')

## Create a new list holding our INI
newini <- list()
newini[[ "Hello World" ]] <- list(Foo = 'Bar')

## Write structure to file
write.ini(newini, iniFile)

## Check file content
\dontrun{
file.show(iniFile)
}

}
\seealso{
\code{\link{read.ini}}
}

