% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.gorillas.R
\docType{data}
\name{gorillas}
\alias{gorillas}
\title{Gorilla nesting sites}
\format{
The data are a list that contains these elements:
\describe{
\item{\code{nests}:}{ A \code{SpatialPointsDataFrame} object containing the locations of
the gorilla nests.}
\item{\code{boundary}:}{ An \code{SpatialPolygonsDataFrame} object defining the boundary
of the region that was searched for the nests.}
\item{\code{mesh}:}{ An \code{inla.mesh} object containing a mesh that can be used
with function \code{lgcp} to fit a LGCP to the nest data.}
\item{\code{gcov}:}{ A list of SpatialGridDataFrame objects, one for each of these spatial covariates:
\describe{
\item{\code{aspect}}{ Compass direction of the terrain slope. Categorical, with levels
N, NE, E, SE, S, SW, W and NW, which are coded as integers 1 to 8.}
\item{\code{elevation}}{ Digital elevation of terrain, in metres.}
\item{\code{heat}}{ Heat Load Index at each point on the surface (Beer's aspect),
discretised. Categorical with values Warmest (Beer's aspect between 0 and 0.999),
Moderate (Beer's aspect between 1 and 1.999), Coolest (Beer's aspect equals 2). These are
coded as integers 1, 2 and 3, in that order.}
\item{\code{slopangle}}{ Terrain slope, in degrees.}
\item{\code{slopetype}}{ Type of slope. Categorical, with values Valley, Toe (toe slope),
Flat, Midslope, Upper and Ridge. These are coded as integers 1 to 6.}
\item{\code{vegetation}}{ Vegetation type: a categorical variable with 6 levels coded as
integers 1 to 6 (in order of increasing expected habitat suitability)}
\item{\code{waterdist}}{ Euclidean distance from nearest water body, in metres.}
}
}
\item{\code{plotsample}}{Plot sample of gorilla nests, sampling 9x9 over the region, with 60\\% coverage. Components:
\describe{
\item{\code{counts}}{ A SpatialPointsDataFrame frame with elements \code{x}, \code{y}, \code{count},
\code{exposure}, being the x- and y-coordinates of the centre of each plot, the count in each
plot and the area of each plot.}
\item{\code{plots}}{ A \code{SpatialPolygonsDataFrame} defining the individual plot boundaries.}
\item{\code{nests}}{ A \code{SpatialPointsDataFrame} giving the locations of each detected nest.}
}
}
}
}
\source{
Library \code{spatstat.data}.
}
\usage{
gorillas
# To avoid the name clash with spatstat.data::gorillas, use
data(gorillas, package = "inlabru")
}
\description{
This is the \code{gorillas} dataset from the package \code{spatstat.data}, reformatted
as point process data for use with \code{inlabru}.
}
\examples{
if (bru_safe_inla() &&
  bru_safe_sp() &&
  require("sp") &&
  require(ggplot2, quietly = TRUE)) {
  data(gorillas, package = "inlabru") # get the data

  # plot all the nests, mesh and boundary
  ggplot() +
    gg(gorillas$mesh) +
    gg(gorillas$boundary) +
    gg(gorillas$nests)

  # Plot the elevation covariate
  plot(gorillas$gcov$elevation)

  # Plot the plot sample
  ggplot() +
    gg(gorillas$plotsample$plots) +
    gg(gorillas$plotsample$nests)
}
}
\references{
Funwi-Gabga, N. (2008) A pastoralist survey and fire impact assessment in the Kagwene Gorilla
Sanctuary, Cameroon. M.Sc. thesis, Geology and Environmental Science, University of Buea,
Cameroon.

Funwi-Gabga, N. and Mateu, J. (2012) Understanding the nesting spatial behaviour of gorillas
in the Kagwene Sanctuary, Cameroon. Stochastic Environmental Research and Risk Assessment
26 (6), 793-811.
}
\keyword{datasets}
