% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot.R
\name{gm}
\alias{gm}
\title{ggplot geom for spatial data}
\usage{
gm(data, ...)
}
\arguments{
\item{data}{an object for which to generate a geom.}

\item{...}{Arguments passed on to \code{\link[=gg]{gg()}}.}
}
\value{
The form of the value returned by gm depends on the class of its argument. See the documentation of the particular methods for details of what is produced by that method.
}
\description{
gm is a wrapper for the \link{gg} method. It will take the first argument and transform its
coordinate system to latitude and longitude. Thereafter, \link{gg} is called using the transformed
data and the arguments provided via \code{...}. gm is intended to replace gg whenever the
data is supposed to be plotted over a spatial map generated by \link{gmap}, which only works
if the coordinate system is latitude/longitude.
}
\examples{
\dontrun{
# Load the Gorilla data
data(gorillas, package = "inlabru")

# Create a base map centered around the nests and plot the boundary as well as the nests
gmap(gorillas$nests, maptype = "satellite") +
  gm(gorillas$boundary) +
  gm(gorillas$nests, color = "white", size = 0.5)
}

}
\seealso{
Other geomes for inla and inlabru predictions: 
\code{\link{gg.data.frame}()},
\code{\link{gg.matrix}()},
\code{\link{gg.prediction}()},
\code{\link{gg}()}

Other geomes for spatial data: 
\code{\link{gg.SpatialGridDataFrame}()},
\code{\link{gg.SpatialLines}()},
\code{\link{gg.SpatialPixelsDataFrame}()},
\code{\link{gg.SpatialPixels}()},
\code{\link{gg.SpatialPoints}()},
\code{\link{gg.SpatialPolygons}()},
\code{\link{gg}()}

Other geomes for meshes: 
\code{\link{gg.inla.mesh.1d}()},
\code{\link{gg.inla.mesh}()},
\code{\link{gg}()}

Other geomes for Raster data: 
\code{\link{gg.RasterLayer}()},
\code{\link{gg}()}
}
\concept{geomes for Raster data}
\concept{geomes for inla and inlabru predictions}
\concept{geomes for meshes}
\concept{geomes for spatial data}
