% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mappers.R
\name{bru_mapper}
\alias{bru_mapper}
\alias{ibm_n}
\alias{ibm_values}
\alias{ibm_amatrix}
\alias{ibm_inla_subset}
\alias{ibm_valid_input}
\alias{bru_mapper.default}
\alias{ibm_inla_subset.default}
\alias{bru_mapper.inla.mesh}
\alias{bru_mapper.inla.mesh.1d}
\alias{bru_mapper_index}
\alias{bru_mapper_linear}
\alias{bru_mapper_matrix}
\alias{bru_mapper_factor}
\alias{bru_mapper_offset}
\alias{bru_mapper_multi}
\alias{bru_mapper_collect}
\alias{bru_mapper_harmonics}
\title{Methods for \code{bru_mapper} objects}
\usage{
bru_mapper(...)

ibm_n(mapper, inla_f = FALSE, ...)

ibm_values(mapper, inla_f = FALSE, ...)

ibm_amatrix(mapper, input, inla_f = FALSE, ...)

ibm_inla_subset(mapper, ...)

ibm_valid_input(mapper, input, inla_f = FALSE, ...)

\method{bru_mapper}{default}(mapper, new_class = NULL, methods = NULL, ...)

\method{ibm_inla_subset}{default}(mapper, ...)

\method{bru_mapper}{inla.mesh}(mesh, ...)

\method{bru_mapper}{inla.mesh.1d}(mesh, indexed = NULL, ...)

bru_mapper_index(n = 1L, ...)

bru_mapper_linear(...)

bru_mapper_matrix(labels, ...)

bru_mapper_factor(values, factor_mapping, ...)

bru_mapper_offset(...)

bru_mapper_multi(mappers, ...)

bru_mapper_collect(mappers, hidden = FALSE, ...)

bru_mapper_harmonics(
  order = 1,
  scaling = 1,
  intercept = TRUE,
  interval = c(0, 1),
  ...
)
}
\arguments{
\item{\dots}{Arguments passed on to other methods}

\item{mapper}{A mapper S3 object, normally inheriting from \code{bru_mapper}.
For the default \code{bru_mapper} method, a list that will be converted to a
\code{bru_mapper} object by adding class information and (optional) methods.}

\item{inla_f}{logical; when \code{TRUE} in \code{ibm_n}, \code{ibm_values}, and
\code{ibm_amatrix} methods, these must result in values compatible with \code{INLA::f(...)}
an specification and corresponding \code{INLA::inla.stack(...)} constructions.
Implementations do not normally need to do anything different, except
for mappers of the type needed for hidden multicomponent models such
as "bym2", which can be handled by \code{bru_mapper_collect}.}

\item{input}{The values for which to produce validity information}

\item{new_class}{If non-\code{NULL}, this is added at the front of the class definition}

\item{methods, }{optional \code{list} of named method definitions; See Details.}

\item{mesh}{An \code{inla.mesh.1d} or \code{inla.mesh.2d} object to use as a mapper}

\item{indexed}{logical; If \code{TRUE}, the \code{ibm_values()} output will be the
integer indexing sequence for the latent variables (needed for \code{spde} models).
If \code{FALSE}, the knot
locations are returned (useful as an interpolator for \code{rw2} models
and similar).
Default: \code{NULL}, to force user specification of this parameter}

\item{n}{Size of a model for \code{bru_mapper_index}}

\item{labels}{Column labels for matrix mappings}

\item{values}{Input values calculated by \code{\link[=input_eval.bru_input]{input_eval.bru_input()}}}

\item{factor_mapping}{character; selects the type of factor mapping.
\itemize{
\item \code{'contrast'} for leaving out the first factor level.
\item \code{'full'} for keeping all levels.
}}

\item{mappers}{A list of \code{bru_mapper} objects}

\item{hidden}{\code{logical}, set to \code{TRUE} to flag that the mapper is to be used
as a first level input mapper for \code{INLA::f()} in a model that requires making
only the first mapper visible to \code{INLA::f()} and \code{INLA::inla.stack()}, such
as for "bym2" models, as activated by the \code{inla_f} argument to \code{ibm_n},
\code{ibm_values}, and \code{ibm_amatrix}. Set to \code{FALSE} to always access the full
mapper, e.g. for \code{rgeneric} models}

\item{order}{For \code{bru_mapper_harmonics}, specifies the maximum \code{cos}/\code{sin}
order. (Default 1)}

\item{scaling}{For \code{bru_mapper_harmonics}, specifies an optional vector of
scaling factors of length \code{intercept + order}, or a common single scalar.}

\item{intercept}{logical; For \code{bru_mapper_harmonics}, if \code{TRUE}, the first
basis function is a constant. (Default \code{TRUE})}

\item{interval}{numeric length-2 vector specifying a domain interval.
Default \code{c(0, 1)}.}
}
\description{
Methods for \code{bru_mapper} objects
}
\details{
\itemize{
\item \code{bru_mapper} Generic mapper S3 constructor. See below for details of the
default constructor that can be used to define new mappers in user code.
}

\itemize{
\item \code{ibm_n} Generic. Implementations must return the size of the latent vector
being mapped to.
}

\itemize{
\item \code{ibm_values} Generic. Implementations must return a vector that
would be interpretable by an \code{INLA::f(..., values = ...)} specification.
The exception is the method for \code{bru_mapper_multi}, that returns a
multi-column data frame
}

\itemize{
\item \code{ibm_amatrix} Generic.
Implementations must return a (sparse) matrix of size \code{NROW(input)}
(except for the \code{bru_mapper_multi} and \code{bru_mapper_collect} methods,
that require \code{list()} inputs, and the input size is determined by the
combined inputs)
by \code{ibm_n(mapper, inla_f = FALSE)}. The \code{inla_f=TRUE} argument should only affect
the allowed type of input format.
}

\itemize{
\item \code{ibm_inla_subset} Generic.
Implementations must return a logical vector of \code{TRUE/FALSE} for
the subset such that, given the full A matrix and values output,
\code{A[, subset, drop = FALSE]} and \code{values[subset]}
(or \code{values[subset, , drop = FALSE]} for data.frame values) are equal
to the \code{inla_f = TRUE} version of A and values. The default method uses
the \code{ibm_values} output to construct the subset indexing.
}

\itemize{
\item \code{ibm_valid_input} Generic.
Implementations must return a logical vector of length \code{NROW(input)} (
or for \code{bru_mapper_multi} and \code{bru_mapper_collect} a list of such
vectors)
}

\itemize{
\item \code{bru_mapper.default} adds the "bru_mapper" class and \code{new_class}
to an object. If provided, mapper method functions are added to an environment
\code{.envir} in the object.  The generic methods \code{ibm_n}, \code{ibm_n_inla},
\code{ibm_values}, \code{ibm_values_inla},
\code{ibm_amatrix}, \code{ibm_amatrix_inla},
\code{ibm_valid_input}, and \code{ibm_valid_input_inla} look for these
functions first,
and otherwise call \code{UseMethod()}.  This is an alternative to using \code{.S3method()}
to register the methods, e.g.
\code{.S3method("ibm_amatrix", "my_mapper_class", ibm_amatrix.my_mapper_class)}.
}

\itemize{
\item The default \code{ibm_inla_subset} method uses
the \code{ibm_values} output to construct the inla subset indexing, passing
extra arguments such as \code{multi} on to the methods (this means it supports
both regular vector values and \code{multi=1} data.frame values).
}

\itemize{
\item \code{bru_mapper_multi} constructs a kronecker product mapping
}

\itemize{
\item \code{bru_mapper_collect} constructs concatenated collection mapping
}

\itemize{
\item \code{bru_mapper_harmonics} constructs a mapper for \code{cos}/\code{sin} functions
of orders 1 (if \code{intercept} is \code{TRUE}, otherwise 0) through \code{order}. The total
number of basis functions is \code{intercept + 2 * order}.

Optionally, each order can be given a non-unit scaling, via the \code{scaling}
vector, of length \code{intercept + order}. This can be used to
give an effective spectral prior. For example, let

\if{html}{\out{<div class="sourceCode">}}\preformatted{scaling = 1 / (1 + (0:4)^2)
A1 = bru_mapper_harmonics(order = 4)
u1 <- A1 \%*\% rnorm(9, sd = scaling)
}\if{html}{\out{</div>}}

Then, with

\if{html}{\out{<div class="sourceCode">}}\preformatted{A2 = bru_mapper_harmonics(order = 4, scaling = scaling)
u2 = A2 \%*\% rnorm(9)
}\if{html}{\out{</div>}}

the stochastic properties of \code{u1} and \code{u2} will be the same, with \code{scaling^2}
determining the variance for each frequency contribution.

The period for the first order harmonics is shifted and scaled to match
\code{interval}.
}
}
\examples{
mapper <- bru_mapper_index(5)
ibm_amatrix(mapper, c(1, 3, 4, 5, 2))
}
\seealso{
\link{bru_mapper_methods} for specific method implementations.
}
