% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{as_posix_ct}
\alias{as_posix_ct}
\title{Date-Time Conversion}
\usage{
as_posix_ct(dt, tm, tm_unset = "12:00", tz = "")
}
\arguments{
\item{dt}{'character' vector.
Calendar date formatted as YYYY-MM-DD.}

\item{tm}{'character' vector.
Time in Greenwich Mean Time (UTC) formatted as HH:MM.
Vector length equal to the length of \code{dt}.}

\item{tm_unset}{'character' string.
Value if time is missing, noon by default.}

\item{tz}{'character' string.
Time zone specification to convert to.}
}
\value{
Returns an object of class 'POSIXct'.
}
\description{
Convert calendar date and times.
}
\examples{
as_posix_ct(
  dt = c("2024-01-01", "2024-02-15", NA),
  tm = c("14:30", NA, "11:11"),
  tz = "America/Denver"
)
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{internal}
