% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExportRasterStack.R
\name{ExportRasterStack}
\alias{ExportRasterStack}
\title{Export Raster Stack}
\usage{
ExportRasterStack(rs, path, zip = "", col = grDevices::rainbow(250, start =
  0, end = 0.8))
}
\arguments{
\item{rs}{'RasterStack'.
A collection of \code{\linkS4class{RasterLayer}} objects with the same extent and resolution.}

\item{path}{'character'.
Path name to write raster stack.}

\item{zip}{'character'.
If there is no zip program on your path (on windows),
you can supply the full path to a \file{zip.exe} here, in order to make a KMZ file.}

\item{col}{'character'.
Vector of colors}
}
\value{
Used for the side-effect files written to disk.
}
\description{
This function writes a raster-stack, a collection of raster layers,
to local directories using multiple file formats.
}
\details{
Five local directories are created under \code{path} and named after their intended file formats:
  Comma-Separated Values (\file{csv}),
  Portable Network Graphics (\file{png}),
  Georeferenced TIFF (\file{tif}),
  R Data (\file{rda}), and
  Keyhole Markup Language (\file{kml}).
  For its reference system, \file{kml} uses geographic coordinates:
  longitude and latitude components as defined by the World Geodetic System of 1984.
  Therefore, the conversion of gridded data between cartographic projections may introduce a new source of error.

  To install \file{zip.exe} on windows, download the latest binary version from the
  \href{https://www.7-zip.org/download.html}{Info-ZIP} website;
  select one of the given FTP locations, enter directory \file{win32}, download \file{zip300xn.zip}, and extract.
}
\examples{
\dontrun{
  f <- "SIR2016-5080/ancillary/uncalibrated/data/rda/rasters.rda"
  load(file = f)
  ExportRasterStack(rs, tempdir())
}

}
\seealso{
\code{\link[raster]{writeRaster}}
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{IO}
