% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{f_ll_hmm}
\alias{f_ll_hmm}
\title{Log-likelihood function of the Poisson-hidden Markov model}
\usage{
f_ll_hmm(theta, data, N = 2, neg = FALSE)
}
\arguments{
\item{theta}{A numeric vector of model parameters.}

\item{data}{A \code{data.frame} that includes a time series of counts.}

\item{N}{The number of states in the hidden Markov model.}

\item{neg}{Set to \code{TRUE} to return the negative log-likelihood value.}
}
\value{
The log-likelihood value at \code{theta}.
}
\description{
Log-likelihood function of the Poisson-hidden Markov model
}
\details{
The example uses a data set that covers the number of major earthquakes
(magnitude 7 or greater) in the world from 1900 until 2006.
}
\examples{
data(earthquakes, package = "ino")
f_ll_hmm(theta = c(-1, -1, 1, 2), data = earthquakes, N = 2)

}
\references{
https://en.wikipedia.org/wiki/Hidden_Markov_model
}
\keyword{function}
\keyword{internal}
