#' Citation information for a subset of host-pathogen interactions
#'
#' Edgelist of known associations between insect host (`Host`) and pathogen (`Pathogen`), and
#' associated references and indexing values. These data are smaller than assocref, which provides
#' more data on host-parasite interactions. CreationDate and ModificationDate are incorrect. The
#' variables are as follows:
#'
#' \itemize{
#'   \item CitationCode. Citation code
#'   \item Reference. Actual citation
#'   \item CreationDate. Record creation date
#'   \item ModificationDate. Record modification date
#'   \item ReadBy. Comments about the reading and identity of reader 
#'   \item GetIt. Notes on article acquisition    
#'   \item nvpCount. Number of pathogens reported in the citation.
#'  }
#'
#' @docType data
#' @keywords datasets
#' @name citation
#' @usage data(citation)
#' @format A data.frame with 1966 observations



"citation"
