% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/n_parameters.R
\name{n_parameters}
\alias{n_parameters}
\alias{n_parameters.default}
\alias{n_parameters.merMod}
\alias{n_parameters.glmmTMB}
\alias{n_parameters.zeroinfl}
\alias{n_parameters.gam}
\alias{n_parameters.brmsfit}
\title{Count number of parameters in a model}
\usage{
n_parameters(x, ...)

\method{n_parameters}{default}(x, remove_nonestimable = FALSE, ...)

\method{n_parameters}{merMod}(
  x,
  effects = c("fixed", "random"),
  remove_nonestimable = FALSE,
  ...
)

\method{n_parameters}{glmmTMB}(
  x,
  effects = c("fixed", "random"),
  component = c("all", "conditional", "zi", "zero_inflated"),
  remove_nonestimable = FALSE,
  ...
)

\method{n_parameters}{zeroinfl}(
  x,
  component = c("all", "conditional", "zi", "zero_inflated"),
  remove_nonestimable = FALSE,
  ...
)

\method{n_parameters}{gam}(
  x,
  component = c("all", "conditional", "smooth_terms"),
  remove_nonestimable = FALSE,
  ...
)

\method{n_parameters}{brmsfit}(x, effects = "all", component = "all", ...)
}
\arguments{
\item{x}{A statistical model.}

\item{...}{Arguments passed to or from other methods.}

\item{remove_nonestimable}{Logical, if \code{TRUE}, removes (i.e. does not
count) non-estimable parameters (which may occur for models with
rank-deficient model matrix).}

\item{effects}{Should number of parameters for fixed effects, random effects
or both be returned? Only applies to mixed models. May be abbreviated.}

\item{component}{Should total number of parameters, number parameters for the
conditional model, the zero-inflated part of the model, the dispersion term
or the instrumental variables be returned? Applies to models with
zero-inflated and/or dispersion formula, or to models with instrumental
variable (so called fixed-effects regressions). May be abbreviated.}
}
\value{
The number of parameters in the model.
}
\description{
Returns the number of parameters (coefficients) of a model.
}
\note{
This function returns the number of parameters for the fixed effects by
default, as returned by \code{find_parameters(x, effects = "fixed")}. It does not
include \emph{all} estimated model parameters, i.e. auxiliary parameters like
sigma or dispersion are not counted. To get the number of \emph{all estimated}
parameters, use \code{get_df(x, type = "model")}.
}
\examples{
data(iris)
model <- lm(Sepal.Length ~ Sepal.Width * Species, data = iris)
n_parameters(model)
}
