% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_parameters.R
\name{get_parameters}
\alias{get_parameters}
\alias{get_parameters.default}
\title{Get model parameters}
\usage{
get_parameters(x, ...)

\method{get_parameters}{default}(x, verbose = TRUE, ...)
}
\arguments{
\item{x}{A fitted model.}

\item{...}{Currently not used.}

\item{verbose}{Toggle messages and warnings.}
}
\value{
\itemize{
\item for non-Bayesian models, a data frame with two columns: the parameter names and the related point estimates.
\item for Anova (\code{aov()}) with error term, a list of parameters for the conditional and the random effects parameters
}
}
\description{
Returns the coefficients (or posterior samples for Bayesian
models) from a model. See the documentation for your object's class:
\itemize{
\item{\link[=get_parameters.BGGM]{Bayesian models} (\pkg{rstanarm}, \pkg{brms}, \pkg{MCMCglmm}, ...)}
\item{\link[=get_parameters.emmGrid]{Estimated marginal means} (\pkg{emmeans})}
\item{\link[=get_parameters.gamm]{Generalized additive models} (\pkg{mgcv}, \pkg{VGAM}, ...)}
\item{\link[=get_parameters.betamfx]{Marginal effects models} (\pkg{mfx})}
\item{\link[=get_parameters.glmm]{Mixed models} (\pkg{lme4}, \pkg{glmmTMB}, \pkg{GLMMadaptive}, ...)}
\item{\link[=get_parameters.zeroinfl]{Zero-inflated and hurdle models} (\pkg{pscl}, ...)}
\item{\link[=get_parameters.betareg]{Models with special components} (\pkg{betareg}, \pkg{MuMIn}, ...)}
\item{\link[=get_parameters.htest]{Hypothesis tests} (\code{htest})}
}
}
\details{
In most cases when models either return different "effects" (fixed,
random) or "components" (conditional, zero-inflated, ...), the arguments
\code{effects} and \code{component} can be used.
\cr \cr
\code{get_parameters()} is comparable to \code{coef()}, however, the coefficients
are returned as data frame (with columns for names and point estimates of
coefficients). For Bayesian models, the posterior samples of parameters are
returned.
}
\section{Model components}{

Possible values for the \code{component} argument depend on the model class.
Following are valid options:
\itemize{
\item \code{"all"}: returns all model components, applies to all models, but will only
have an effect for models with more than just the conditional model component.
\item \code{"conditional"}: only returns the conditional component, i.e. "fixed effects"
terms from the model. Will only have an effect for models with more than
just the conditional model component.
\item \code{"smooth_terms"}: returns smooth terms, only applies to GAMs (or similar
models that may contain smooth terms).
\item \code{"zero_inflated"} (or \code{"zi"}): returns the zero-inflation component.
\item \code{"dispersion"}: returns the dispersion model component. This is common
for models with zero-inflation or that can model the dispersion parameter.
\item \code{"instruments"}: for instrumental-variable or some fixed effects regression,
returns the instruments.
\item \code{"location"}: returns location parameters such as \code{conditional},
\code{zero_inflated}, \code{smooth_terms}, or \code{instruments} (everything that are
fixed or random effects - depending on the \code{effects} argument - but no
auxiliary parameters).
\item \code{"distributional"} (or \code{"auxiliary"}): components like \code{sigma}, \code{dispersion},
\code{beta} or \code{precision} (and other auxiliary parameters) are returned.
}
}

\examples{
data(mtcars)
m <- lm(mpg ~ wt + cyl + vs, data = mtcars)
get_parameters(m)
}
