% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_parameters_other.R
\name{find_parameters.averaging}
\alias{find_parameters.averaging}
\alias{find_parameters.glmgee}
\alias{find_parameters.betareg}
\alias{find_parameters.DirichletRegModel}
\alias{find_parameters.mjoint}
\alias{find_parameters.glmx}
\title{Find model parameters from models with special components}
\usage{
\method{find_parameters}{averaging}(x, component = c("conditional", "full"), flatten = FALSE, ...)

\method{find_parameters}{glmgee}(
  x,
  component = c("all", "conditional", "dispersion"),
  flatten = FALSE,
  ...
)

\method{find_parameters}{betareg}(
  x,
  component = c("all", "conditional", "precision", "location", "distributional",
    "auxiliary"),
  flatten = FALSE,
  ...
)

\method{find_parameters}{DirichletRegModel}(
  x,
  component = c("all", "conditional", "precision", "location", "distributional",
    "auxiliary"),
  flatten = FALSE,
  ...
)

\method{find_parameters}{mjoint}(
  x,
  component = c("all", "conditional", "survival"),
  flatten = FALSE,
  ...
)

\method{find_parameters}{glmx}(
  x,
  component = c("all", "conditional", "extra"),
  flatten = FALSE,
  ...
)
}
\arguments{
\item{x}{A fitted model.}

\item{component}{Should all predictor variables, predictor variables for the
conditional model, the zero-inflated part of the model, the dispersion
term or the instrumental variables be returned? Applies to models
with zero-inflated and/or dispersion formula, or to models with instrumental
variable (so called fixed-effects regressions). May be abbreviated. Note that the
\emph{conditional} component is also called \emph{count} or \emph{mean}
component, depending on the model.}

\item{flatten}{Logical, if \code{TRUE}, the values are returned
as character vector, not as list. Duplicated values are removed.}

\item{...}{Currently not used.}
}
\value{
A list of parameter names. The returned list may have following
elements:
\itemize{
\item \code{conditional}, the "fixed effects" part from the model.
\item \code{full}, parameters from the full model.
}
}
\description{
Returns the names of model parameters, like they typically
appear in the \code{summary()} output.
}
\examples{
data(mtcars)
m <- lm(mpg ~ wt + cyl + vs, data = mtcars)
find_parameters(m)
}
