% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/link_function.R
\name{link_function}
\alias{link_function}
\title{Get link-function from model object}
\usage{
link_function(x, ...)
}
\arguments{
\item{x}{A fitted model.}

\item{...}{Currently not used.}
}
\value{
A function, describing the link-function from a model-object.
   For multivariate-response models, a list of functions is returned.
}
\description{
Returns the link-function from a model object.
}
\examples{
# example from ?stats::glm
counts <- c(18, 17, 15, 20, 10, 20, 25, 13, 12)
outcome <- gl(3, 1, 9)
treatment <- gl(3, 3)
m <- glm(counts ~ outcome + treatment, family = poisson())

link_function(m)(.3)
# same as
log(.3)
}
