% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data.R
\name{get_data}
\alias{get_data}
\alias{get_data.gee}
\alias{get_data.hurdle}
\alias{get_data.glmmTMB}
\alias{get_data.merMod}
\alias{get_data.rlmerMod}
\alias{get_data.mixed}
\alias{get_data.clmm}
\alias{get_data.lme}
\alias{get_data.MixMod}
\alias{get_data.brmsfit}
\alias{get_data.stanreg}
\alias{get_data.MCMCglmm}
\alias{get_data.rqss}
\alias{get_data.nlrq}
\title{Get the data that was used to fit the model}
\usage{
get_data(x, ...)

\method{get_data}{gee}(x, effects = c("all", "fixed", "random"), ...)

\method{get_data}{hurdle}(
  x,
  component = c("all", "conditional", "zi", "zero_inflated", "dispersion"),
  ...
)

\method{get_data}{glmmTMB}(
  x,
  effects = c("all", "fixed", "random"),
  component = c("all", "conditional", "zi", "zero_inflated", "dispersion"),
  ...
)

\method{get_data}{merMod}(x, effects = c("all", "fixed", "random"), ...)

\method{get_data}{rlmerMod}(x, effects = c("all", "fixed", "random"), ...)

\method{get_data}{mixed}(x, effects = c("all", "fixed", "random"), ...)

\method{get_data}{clmm}(x, effects = c("all", "fixed", "random"), ...)

\method{get_data}{lme}(x, effects = c("all", "fixed", "random"), ...)

\method{get_data}{MixMod}(
  x,
  effects = c("all", "fixed", "random"),
  component = c("all", "conditional", "zi", "zero_inflated", "dispersion"),
  ...
)

\method{get_data}{brmsfit}(
  x,
  effects = c("all", "fixed", "random"),
  component = c("all", "conditional", "zi", "zero_inflated"),
  ...
)

\method{get_data}{stanreg}(x, effects = c("all", "fixed", "random"), ...)

\method{get_data}{MCMCglmm}(x, effects = c("all", "fixed", "random"), ...)

\method{get_data}{rqss}(x, effects = c("all", "fixed", "random"), ...)

\method{get_data}{nlrq}(x, ...)
}
\arguments{
\item{x}{A fitted model.}

\item{...}{Currently not used.}

\item{effects}{Should model data for fixed effects, random effects
or both be returned? Only applies to mixed models.}

\item{component}{Should all predictor variables, predictor variables for the
conditional model, the zero-inflated part of the model, the dispersion
term or the instrumental variables be returned? Applies to models
with zero-inflated and/or dispersion formula, or to models with instrumental
variable (so called fixed-effects regressions). May be abbreviated.}
}
\value{
The data that was used to fit the model.
}
\description{
This functions tries to get the data that was used to fit the
  model and returns it as data frame.
}
\note{
Unlike \code{model.frame()}, which may contain transformed variables
  (e.g. if \code{poly()} or \code{scale()} was used inside the formula to
  specify the model), \code{get_data()} aims at returning the "original",
  untransformed data.
}
\examples{
data(cbpp, package = "lme4")
cbpp$trials <- cbpp$size - cbpp$incidence
m <- glm(cbind(incidence, trials) ~ period, data = cbpp, family = binomial)
head(get_data(m))
}
