% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_parameters.R
\name{get_parameters}
\alias{get_parameters}
\alias{get_parameters.default}
\title{Get model parameters}
\usage{
get_parameters(x, ...)

\method{get_parameters}{default}(x, verbose = TRUE, ...)
}
\arguments{
\item{x}{A fitted model.}

\item{...}{Currently not used.}

\item{verbose}{Toggle messages and warnings.}
}
\value{
\itemize{
\item for non-Bayesian models, a data frame with two columns: the parameter names
and the related point estimates.
\item for Anova (\code{aov()}) with error term, a list of parameters for the
conditional and the random effects parameters
}
}
\description{
Returns the coefficients (or posterior samples for Bayesian
models) from a model. See the documentation for your object's class:
\itemize{
\item \link[=get_parameters.BGGM]{Bayesian models} (\strong{rstanarm}, \strong{brms}, \strong{MCMCglmm}, ...)
\item \link[=get_parameters.emmGrid]{Estimated marginal means} (\strong{emmeans})
\item \link[=get_parameters.gamm]{Generalized additive models} (\strong{mgcv}, \strong{VGAM}, ...)
\item \link[=get_parameters.betamfx]{Marginal effects models} (\strong{mfx})
\item \link[=get_parameters.glmmTMB]{Mixed models} (\strong{lme4}, \strong{glmmTMB}, \strong{GLMMadaptive}, ...)
\item \link[=get_parameters.zeroinfl]{Zero-inflated and hurdle models} (\strong{pscl}, ...)
\item \link[=get_parameters.betareg]{Models with special components} (\strong{betareg}, \strong{MuMIn}, ...)
\item \link[=get_parameters.htest]{Hypothesis tests} (\code{htest})
}
}
\details{
In most cases when models either return different "effects" (fixed,
random) or "components" (conditional, zero-inflated, ...), the arguments
\code{effects} and \code{component} can be used.

\code{get_parameters()} is comparable to \code{coef()}, however, the coefficients
are returned as data frame (with columns for names and point estimates of
coefficients). For Bayesian models, the posterior samples of parameters are
returned.
}
\section{Model components}{

Possible values for the \code{component} argument depend on the model class.
Following are valid options:
\itemize{
\item \code{"all"}: returns all model components, applies to all models, but will only
have an effect for models with more than just the conditional model component.
\item \code{"conditional"}: only returns the conditional component, i.e. "fixed effects"
terms from the model. Will only have an effect for models with more than
just the conditional model component.
\item \code{"smooth_terms"}: returns smooth terms, only applies to GAMs (or similar
models that may contain smooth terms).
\item \code{"zero_inflated"} (or \code{"zi"}): returns the zero-inflation component.
\item \code{"dispersion"}: returns the dispersion model component. This is common
for models with zero-inflation or that can model the dispersion parameter.
\item \code{"instruments"}: for instrumental-variable or some fixed effects regression,
returns the instruments.
\item \code{"nonlinear"}: for non-linear models (like models of class \code{nlmerMod} or
\code{nls}), returns staring estimates for the nonlinear parameters.
\item \code{"correlation"}: for models with correlation-component, like \code{gls}, the
variables used to describe the correlation structure are returned.
\item \code{"location"}: returns location parameters such as \code{conditional},
\code{zero_inflated}, \code{smooth_terms}, or \code{instruments} (everything that are
fixed or random effects - depending on the \code{effects} argument - but no
auxiliary parameters).
\item \code{"distributional"} (or \code{"auxiliary"}): components like \code{sigma}, \code{dispersion},
\code{beta} or \code{precision} (and other auxiliary parameters) are returned.
}

\strong{Special models}

Some model classes also allow rather uncommon options. These are:
\itemize{
\item \strong{mhurdle}: \code{"infrequent_purchase"}, \code{"ip"}, and \code{"auxiliary"}
\item \strong{BGGM}: \code{"correlation"} and \code{"intercept"}
\item \strong{BFBayesFactor}, \strong{glmx}: \code{"extra"}
\item \strong{averaging}:\code{"conditional"} and \code{"full"}
\item \strong{mjoint}: \code{"survival"}
\item \strong{mfx}: \code{"precision"}, \code{"marginal"}
\item \strong{betareg}, \strong{DirichletRegModel}: \code{"precision"}
\item \strong{mvord}: \code{"thresholds"} and \code{"correlation"}
\item \strong{clm2}: \code{"scale"}
\item \strong{selection}: \code{"selection"}, \code{"outcome"}, and \code{"auxiliary"}
}

For models of class \code{brmsfit} (package \strong{brms}), even more options are
possible for the \code{component} argument, which are not all documented in detail
here. It can be any pre-defined or arbitrary distributional parameter, like
\code{mu}, \code{ndt}, \code{kappa}, etc.
}

\examples{
data(mtcars)
m <- lm(mpg ~ wt + cyl + vs, data = mtcars)
get_parameters(m)
}
