% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspect_imb.R
\name{inspect_imb}
\alias{inspect_imb}
\title{Summary and comparison of the most common levels in categorical columns}
\usage{
inspect_imb(df1, df2 = NULL, include_na = FALSE)
}
\arguments{
\item{df1}{A dataframe.}

\item{df2}{An optional second data frame for comparing columnwise imbalance.
Defaults to \code{NULL}.}

\item{include_na}{Logical flag, whether to include missing values as a unique level.  Default
is \code{FALSE} - to ignore \code{NA} values.}
}
\value{
A tibble summarising and comparing the imbalance for each categorical column 
in one or a pair of dataframes.
}
\description{
For a single dataframe, summarise the most common level in each 
categorical column. If two dataframes are supplied, compare the most common 
levels of categorical features appearing in both dataframes.  For grouped 
dataframes, summarise the levels of categorical columns in the dataframe
split by group.
}
\details{
For a \strong{single dataframe}, the tibble returned contains the columns: \cr
\itemize{
  \item \code{col_name}, a character vector containing column names of \code{df1}.
  \item \code{value}, a character vector containing the most common categorical level 
  in each column of \code{df1}.
  \item \code{pcnt}, the relative frequency of each column's most common categorical level 
  expressed as a percentage.
  \item \code{cnt}, the number of occurrences of the most common categorical level in each
  column of \code{df1}.
}
For a \strong{pair of dataframes}, the tibble returned contains the columns: \cr
\itemize{
  \item \code{col_name}, a character vector containing names of the unique columns in \code{df1} 
  and \code{df2}.
  \item \code{value}, a character vector containing the most common categorical level 
  in each column of \code{df1}.  
  \item \code{pcnt_1}, \code{pcnt_2}, the percentage occurrence of \code{value} in 
  the column \code{col_name} for each of \code{df1} and \code{df2}, respectively.
  \item \code{cnt_1}, \code{cnt_2}, the number of occurrences of of \code{value} in 
  the column \code{col_name} for each of \code{df1} and \code{df2}, respectively.
  \item \code{p_value}, p-value associated with the null hypothesis that the true rate of 
  occurrence is the same for both dataframes.  Small values indicate stronger evidence of a difference
  in the rate of occurrence.
}
For a \strong{grouped dataframe}, the tibble returned is as for a single dataframe, but where 
the first \code{k} columns are the grouping columns.  There will be as many rows in the result 
as there are unique combinations of the grouping variables.
}
\examples{
# Load dplyr for starwars data & pipe
library(dplyr)

# Single dataframe summary
inspect_imb(starwars)

# Paired dataframe comparison
inspect_imb(starwars, starwars[1:20, ])

# Grouped dataframe summary
starwars \%>\% group_by(gender) \%>\% inspect_imb()
}
\seealso{
\code{\link{inspect_cat}}, \code{\link{show_plot}}
}
\author{
Alastair Rushworth
}
