% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspect_mem.R
\name{inspect_mem}
\alias{inspect_mem}
\title{Summarise and compare the memory usage in one or two dataframes.}
\usage{
inspect_mem(df1, df2 = NULL, show_plot = FALSE)
}
\arguments{
\item{df1}{A data frame.}

\item{df2}{An optional second data frame with which to comparing memory usage.
Defaults to \code{NULL}.}

\item{show_plot}{(Deprecated) Logical flag indicating whether a plot should be shown.
Superseded by the function \code{show_plot()} and will be dropped in a future version.}
}
\value{
A tibble summarising and comparing the columnwise memory usage 
for one or a pair of data frames.
}
\description{
Summarise and compare the memory usage in one or two dataframes.
}
\details{
When \code{df1} is specified and \code{df2 = NULL}, a tibble summarising 
columnwise memory usage in descending order of size is returned:
\itemize{
  \item \code{col_name}   character vector containing column names of \code{df1}.
  \item \code{size}  character vector containing display-friendly memory usage of each column.
  \item \code{pcnt}  the percentage of the dataframe's total memory footprint 
  used by each column.
}
When both \code{df1} and \code{df2} are specified, column memory usages are jointly 
tabulated for both data frames.  Rows are sorted in descending order of size as 
they appear in \code{df1}:
\itemize{
  \item \code{col_name} character vector containing column names of \code{df1}
  and \code{df2}.
  \item \code{size_1}, \code{size_2} character vector containing memory usage of each column in
  each of \code{df1} and \code{df2}.
  \item \code{pcnt_1}, \code{pcnt_2} the percentage of total memory usage of each column within 
  each of \code{df1} and \code{df2}.
}
}
\examples{
data("starwars", package = "dplyr")
# get tibble of column memory usage for the starwars data
inspect_mem(starwars)
# compare memory usage 
inspect_mem(starwars, starwars[1:10, -3])
}
