stan_test("stan_package_create()", {
  skip_cmdstan()
  temp <- tempfile()
  dir.create(temp)
  stan_package_configure(path = temp)
  cleanup <- file.path(temp, "cleanup")
  cleanup_win <- file.path(temp, "cleanup.win")
  configure <- file.path(temp, "configure")
  configure_win <- file.path(temp, "configure.win")
  expect_true(file.exists(cleanup))
  expect_true(file.exists(cleanup_win))
  expect_true(file.exists(configure))
  expect_true(file.exists(configure_win))
  lines_cleanup <- paste(readLines(cleanup), collapse = "\n")
  lines_cleanup_win <- paste(readLines(cleanup_win), collapse = "\n")
  lines_configure <- paste(readLines(configure), collapse = "\n")
  lines_configure_win <- paste(readLines(configure_win), collapse = "\n")
  expect_false(any(lines_cleanup == lines_cleanup_win))
  expect_false(any(lines_configure == lines_configure_win))
  expect_false(any(lines_cleanup == lines_configure))
  expect_false(any(lines_cleanup_win == lines_configure_win))
  expect_false(any(lines_cleanup == lines_configure_win))
  expect_false(any(lines_configure == lines_cleanup_win))
  expect_true(any(grepl("stan_package_clean", lines_cleanup)))
  expect_true(any(grepl("stan_package_clean", lines_cleanup_win)))
  expect_true(any(grepl("stan_package_compile", lines_configure)))
  expect_true(any(grepl("stan_package_compile", lines_configure_win)))
})
